/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.gef.dnd.IDndClient;
import org.xmind.ui.util.Logger;

public class DndClientDescriptor {
    private IConfigurationElement element;
    private String id;
    private IDndClient dndClient;
    private boolean failed = false;

    public DndClientDescriptor(IConfigurationElement element) throws CoreException {
        this.element = element;
        this.load();
    }

    private void load() throws CoreException {
        this.id = this.element.getAttribute("id");
        if (RegistryReader.getClassValue((IConfigurationElement)this.element, (String)"class") == null) {
            throw new CoreException((IStatus)new Status(4, this.element.getNamespaceIdentifier(), 0, "Invalid extension (missing class name): " + this.id, null));
        }
    }

    public String getId() {
        return this.id;
    }

    public IDndClient getDndClient() {
        if (this.dndClient == null) {
            if (this.failed) {
                return null;
            }
            try {
                this.dndClient = (IDndClient)this.element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Logger.log(e, "Failed to create DND Client: " + RegistryReader.getClassValue((IConfigurationElement)this.element, (String)"class"));
                this.failed = true;
            }
        }
        return this.dndClient;
    }
}

