/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.branch;

import java.util.List;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.style.StyleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchStructureData {
    private IBranchPart branch;
    private int majorSpacing = -1;
    private int minorSpacing = -1;

    public BranchStructureData(IBranchPart branch) {
        this.branch = branch;
    }

    protected IBranchPart getBranch() {
        return this.branch;
    }

    protected List<IBranchPart> getSubBranches() {
        return this.getBranch().getSubBranches();
    }

    protected int getMinorSpacing() {
        if (this.minorSpacing < 0) {
            this.minorSpacing = StyleUtils.getInteger(this.getBranch(), this.getBranch().getBranchPolicy().getStyleSelector(this.getBranch()), "spacing-minor", 5);
        }
        return this.minorSpacing;
    }

    protected int getMajorSpacing() {
        if (this.majorSpacing < 0) {
            this.majorSpacing = StyleUtils.getMajorSpacing(this.getBranch(), 5);
        }
        return this.majorSpacing;
    }

    protected boolean isInSameRangeWithLast(List<IBranchPart> subBranches, int index) {
        if (index <= 0 || index >= subBranches.size()) {
            return false;
        }
        return this.isInSameRange(subBranches.get(index - 1), subBranches.get(index));
    }

    protected boolean isInSameRange(IBranchPart child1, IBranchPart child2) {
        for (IBoundaryPart boundary : this.getBranch().getBoundaries()) {
            if (!this.containsBoth(boundary, child1, child2)) continue;
            return true;
        }
        for (ISummaryPart summary : this.getBranch().getSummaries()) {
            if (!this.containsBoth(summary, child1, child2)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsBoth(IBranchRangePart range, IBranchPart child1, IBranchPart child2) {
        return range.encloses(child1) && range.encloses(child2);
    }
}

