/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.IChecksumStream;
import org.xmind.core.IEncryptionData;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.internal.dom.FileEntryImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.security.Crypto;
import org.xmind.core.internal.zip.ZipStreamOutputTarget;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;

public class WorkbookSaver {
    private WorkbookImpl workbook;
    private IOutputTarget target;
    private String file;
    private Set<String> savedEntries;

    public WorkbookSaver(WorkbookImpl workbook, String file) {
        this.workbook = workbook;
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public void save() throws IOException, CoreException {
        this.save(this.target, this.file);
    }

    public void save(OutputStream output) throws IOException, CoreException {
        this.save(new ZipStreamOutputTarget(new ZipOutputStream(output)), null);
    }

    public void save(String file) throws IOException, CoreException {
        this.save(null, file);
    }

    public void save(IOutputTarget target) throws IOException, CoreException {
        this.save(target, null);
    }

    private void save(IOutputTarget target, String file) throws IOException, CoreException {
        if (target == null && file != null) {
            target = new ZipStreamOutputTarget(new ZipOutputStream(new FileOutputStream(file)));
        }
        this.file = file;
        if (target == null) {
            throw new FileNotFoundException("No target when saving.");
        }
        try {
            this.doSave(target);
        }
        finally {
            if (target instanceof ZipStreamOutputTarget) {
                ((ZipStreamOutputTarget)target).close();
            }
        }
    }

    private void doSave(IOutputTarget target) throws FileNotFoundException, IOException, CoreException {
        this.target = target;
        this.savedEntries = null;
        try {
            this.doSave();
        }
        catch (Throwable throwable) {
            try {
                this.clearEncryptionData();
            }
            catch (Throwable throwable2) {}
            this.savedEntries = null;
            throw throwable;
        }
        try {
            this.clearEncryptionData();
        }
        catch (Throwable throwable) {}
        this.savedEntries = null;
    }

    private void doSave() throws IOException, CoreException {
        this.saveMeta();
        this.saveContent();
        this.saveMarkerSheet();
        this.saveStyleSheet();
        this.copyOtherStaff();
        this.saveManifest();
    }

    private void saveManifest() throws IOException, CoreException {
        this.saveDOM(this.workbook.getManifest(), this.target, "META-INF/manifest.xml");
    }

    private void saveStyleSheet() throws IOException, CoreException {
        IStyleSheet styleSheet = this.workbook.getStyleSheet();
        if (!styleSheet.isEmpty()) {
            this.saveDOM(styleSheet, this.target, "styles.xml");
        }
    }

    private void saveMarkerSheet() throws IOException, CoreException {
        IMarkerSheet markerSheet = this.workbook.getMarkerSheet();
        if (!markerSheet.isEmpty()) {
            this.saveDOM(markerSheet, this.target, "markers/markerSheet.xml");
        }
    }

    private void saveContent() throws IOException, CoreException {
        this.saveDOM(this.workbook, this.target, "content.xml");
    }

    private void saveMeta() throws IOException, CoreException {
        this.saveDOM(this.workbook.getMeta(), this.target, "meta.xml");
    }

    private void copyOtherStaff() throws IOException, CoreException {
        IInputSource source = this.workbook.getTempStorage().getInputSource();
        this.copyAll(source, this.target);
    }

    private void copyAll(IInputSource source, IOutputTarget target) {
        IManifest manifest = this.workbook.getManifest();
        for (IFileEntry entry : manifest.getFileEntries()) {
            String entryPath;
            if (entry.isDirectory() || (entryPath = entry.getPath()) == null || "".equals(entryPath) || "META-INF/manifest.xml".equals(entryPath) || this.hasBeenSaved(entryPath)) continue;
            this.copyEntry(source, target, entryPath);
            this.markSaved(entryPath);
        }
    }

    private void copyEntry(IInputSource source, IOutputTarget target, String entryPath) {
        block7: {
            try {
                OutputStream out;
                InputStream in = this.getInputStream(source, entryPath);
                if (in == null || (out = this.getOutputStream(target, entryPath)) == null) break block7;
                try {
                    FileUtils.transfer(in, out, true);
                }
                finally {
                    long time = source.getEntryTime(entryPath);
                    if (time >= 0L) {
                        target.setEntryTime(entryPath, time);
                    }
                    this.recordChecksum(entryPath, out);
                }
            }
            catch (IOException e) {
                Core.getLogger().log(e);
            }
            catch (CoreException e) {
                Core.getLogger().log(e);
            }
        }
    }

    private InputStream getInputStream(IInputSource source, String entryPath) {
        if (source.hasEntry(entryPath)) {
            return source.getEntryStream(entryPath);
        }
        return null;
    }

    private void clearEncryptionData() {
        for (IFileEntry entry : this.workbook.getManifest().getFileEntries()) {
            entry.deleteEncryptionData();
        }
    }

    private boolean hasBeenSaved(String entryPath) {
        return this.savedEntries != null && this.savedEntries.contains(entryPath);
    }

    private void markSaved(String entryPath) {
        if (this.savedEntries == null) {
            this.savedEntries = new HashSet<String>();
        }
        this.savedEntries.add(entryPath);
    }

    private void saveDOM(IAdaptable domAdapter, IOutputTarget target, String entryPath) throws IOException, CoreException {
        OutputStream out = this.getOutputStream(target, entryPath);
        if (out != null) {
            try {
                DOMUtils.save(domAdapter, out, true);
            }
            finally {
                this.recordChecksum(entryPath, out);
                this.markSaved(entryPath);
            }
        }
    }

    private void recordChecksum(String entryPath, Object checksumProvider) throws IOException {
        String checksum;
        IEncryptionData encData;
        if (checksumProvider instanceof IChecksumStream && (encData = this.workbook.getManifest().getEncryptionData(entryPath)) != null && encData.getChecksumType() != null && (checksum = ((IChecksumStream)checksumProvider).getChecksum()) != null) {
            encData.setAttribute(checksum, "checksum");
        }
    }

    private OutputStream getOutputStream(IOutputTarget target, String entryPath) throws CoreException {
        if (!target.isEntryAvaialble(entryPath)) {
            return null;
        }
        OutputStream out = target.getEntryStream(entryPath);
        if (out == null) {
            return null;
        }
        String password = this.workbook.getPassword();
        if (password == null) {
            return out;
        }
        IFileEntry entry = this.workbook.getManifest().getFileEntry(entryPath);
        if (entry == null) {
            return out;
        }
        if (this.ignoresEncryption(entry, entryPath)) {
            return out;
        }
        IEncryptionData encData = entry.createEncryptionData();
        return Crypto.creatOutputStream(out, true, encData, password);
    }

    private boolean ignoresEncryption(IFileEntry entry, String entryPath) {
        return "META-INF/manifest.xml".equals(entryPath) || ((FileEntryImpl)entry).isIgnoreEncryption();
    }
}

