/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IControlPoint;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.Relationship;
import org.xmind.core.internal.dom.ControlPointImpl;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.dom.WorkbookUtilsImpl;
import org.xmind.core.internal.event.NullCoreEventSupport;
import org.xmind.core.util.DOMUtils;

public class RelationshipImpl
extends Relationship
implements ICoreEventSource {
    private Element implementation;
    private WorkbookImpl ownedWorkbook;
    private Map<Integer, ControlPointImpl> controlPoints = null;
    private ICoreEventSupport coreEventSupport;

    public RelationshipImpl(Element implementation, WorkbookImpl ownedWorkbook) {
        this.implementation = DOMUtils.addIdAttribute(implementation);
        this.ownedWorkbook = ownedWorkbook;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public String getId() {
        return this.implementation.getAttribute("id");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RelationshipImpl)) {
            return false;
        }
        RelationshipImpl r = (RelationshipImpl)obj;
        return this.implementation == r.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return "REL#" + this.getId() + "(" + this.getTitleText() + ")";
    }

    public String getEnd1Id() {
        return DOMUtils.getAttribute(this.implementation, "end1");
    }

    public void setEnd1Id(String id) {
        String oldId = this.getEnd1Id();
        DOMUtils.setAttribute(this.implementation, "end1", id);
        String newId = this.getEnd1Id();
        this.fireValueChange("relationshipEnd1", oldId, newId);
    }

    public String getEnd2Id() {
        return DOMUtils.getAttribute(this.implementation, "end2");
    }

    public void setEnd2Id(String id) {
        String oldId = this.getEnd2Id();
        DOMUtils.setAttribute(this.implementation, "end2", id);
        String newId = this.getEnd2Id();
        this.fireValueChange("relationshipEnd2", oldId, newId);
    }

    public ISheet getParent() {
        Node p = this.implementation.getParentNode();
        if (DOMUtils.isElementByTag(p, "relationships") && DOMUtils.isElementByTag(p = p.getParentNode(), "sheet")) {
            return (ISheet)this.ownedWorkbook.getAdaptable(p);
        }
        return null;
    }

    public void setTitleText(String titleText) {
        String oldText = this.getLocalTitleText();
        DOMUtils.setText(this.implementation, "title", titleText);
        String newText = this.getLocalTitleText();
        this.fireValueChange("titleText", oldText, newText);
    }

    protected String getLocalTitleText() {
        return DOMUtils.getTextContentByTag(this.implementation, "title");
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Element.class || adapter == Node.class) {
            return this.implementation;
        }
        return super.getAdapter(adapter);
    }

    public boolean checkAvailable() {
        ISheet sheet1;
        IRelationshipEnd end1 = this.getEnd1();
        IRelationshipEnd end2 = this.getEnd2();
        return end1 != null && end2 != null && (sheet1 = end1.getOwnedSheet()) != null && sheet1.equals(end2.getOwnedSheet());
    }

    public String getStyleId() {
        return DOMUtils.getAttribute(this.implementation, "style-id");
    }

    public void setStyleId(String styleId) {
        String oldValue = this.getStyleId();
        WorkbookImpl workbook = this.getRealizedWorkbook();
        WorkbookUtilsImpl.decreaseStyleRef(workbook, this);
        DOMUtils.setAttribute(this.implementation, "style-id", styleId);
        WorkbookUtilsImpl.increaseStyleRef(workbook, this);
        String newValue = this.getStyleId();
        this.fireValueChange("style", oldValue, newValue);
    }

    public IControlPoint getControlPoint(int index) {
        ControlPointImpl controlPoint;
        if (this.controlPoints == null) {
            this.controlPoints = new HashMap<Integer, ControlPointImpl>();
        }
        if ((controlPoint = this.controlPoints.get(index)) == null) {
            controlPoint = new ControlPointImpl(this, index);
            this.controlPoints.put(index, controlPoint);
        }
        return controlPoint;
    }

    protected WorkbookImpl getRealizedWorkbook() {
        ISheet sheet = this.getParent();
        if (sheet != null && this.ownedWorkbook == sheet.getParent()) {
            return this.ownedWorkbook;
        }
        return null;
    }

    protected void addNotify(WorkbookImpl workbook, SheetImpl parent) {
        this.setCoreEventSupport(parent.getCoreEventSupport());
        WorkbookUtilsImpl.increaseStyleRef(workbook, this);
    }

    protected void removeNotify(WorkbookImpl workbook, SheetImpl parent) {
        WorkbookUtilsImpl.decreaseStyleRef(workbook, this);
        this.setCoreEventSupport(null);
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    public void setCoreEventSupport(ICoreEventSupport coreEventSupport) {
        this.coreEventSupport = coreEventSupport;
    }

    public ICoreEventSupport getCoreEventSupport() {
        if (this.coreEventSupport == null) {
            return NullCoreEventSupport.getInstance();
        }
        return this.coreEventSupport;
    }

    private void fireValueChange(String type, Object oldValue, Object newValue) {
        this.getCoreEventSupport().dispatchValueChange(this, type, oldValue, newValue);
    }
}

