/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.internal.ui.model.FeatureAdapter;
import org.eclipse.update.internal.ui.model.IConfiguredFeatureAdapter;
import org.eclipse.update.internal.ui.model.IConfiguredSiteAdapter;
import org.eclipse.update.internal.ui.model.IFeatureAdapter;
import org.eclipse.update.internal.ui.model.MissingFeature;
import org.eclipse.update.internal.ui.model.SimpleFeatureAdapter;

public class ConfiguredFeatureAdapter
extends SimpleFeatureAdapter
implements IConfiguredFeatureAdapter {
    private IConfiguredSiteAdapter adapter;
    private boolean configured;
    private boolean updated;

    public ConfiguredFeatureAdapter(IConfiguredSiteAdapter adapter, IFeature feature, boolean configured, boolean updated, boolean optional) {
        super(feature, optional);
        this.adapter = adapter;
        this.configured = configured;
        this.updated = updated;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof ConfiguredFeatureAdapter) {
            try {
                ConfiguredFeatureAdapter ad = (ConfiguredFeatureAdapter)object;
                return ad.getConfiguredSite().equals(this.getConfiguredSite()) && ad.getFeature(null).equals(this.getFeature(null));
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public IConfiguredSite getConfiguredSite() {
        return this.adapter.getConfiguredSite();
    }

    public IInstallConfiguration getInstallConfiguration() {
        return this.adapter.getInstallConfiguration();
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public IFeatureAdapter[] getIncludedFeatures(IProgressMonitor monitor) {
        try {
            IIncludedFeatureReference[] included = this.getFeature(null).getIncludedFeatureReferences();
            IFeatureAdapter[] result = new ConfiguredFeatureAdapter[included.length];
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
            subMonitor.beginTask("", included.length);
            int i = 0;
            while (i < included.length) {
                IFeature feature;
                IIncludedFeatureReference fref = included[i];
                boolean childConfigured = this.configured;
                boolean updated = false;
                try {
                    feature = fref.getFeature((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1));
                    childConfigured = this.adapter.getConfiguredSite().isConfigured(feature);
                    PluginVersionIdentifier refpid = fref.getVersionedIdentifier().getVersion();
                    PluginVersionIdentifier fpid = feature.getVersionedIdentifier().getVersion();
                    updated = !refpid.equals((Object)fpid);
                }
                catch (CoreException coreException) {
                    feature = new MissingFeature(this.getFeature(null), (IFeatureReference)fref);
                    childConfigured = false;
                }
                result[i] = new ConfiguredFeatureAdapter(this.adapter, feature, childConfigured, updated, fref.isOptional());
                ((FeatureAdapter)result[i]).setIncluded(true);
                ++i;
            }
            return result;
        }
        catch (CoreException coreException) {
            return new IFeatureAdapter[0];
        }
    }
}

