/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.io.ResourceGroup;
import org.xmind.core.util.DOMUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMappingManager {
    private String applicationId;
    private Document implementation;
    private List<ResourceGroup> groups;
    private Map<String, ResourceGroup> map;
    private static DocumentBuilder builder = null;

    private ResourceMappingManager(Document implementation) {
        this.implementation = implementation;
        this.applicationId = DOMUtils.getAttribute((Element)implementation.getDocumentElement(), (String)"application-id");
    }

    private ResourceMappingManager(String applicationId) {
        this.implementation = null;
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public List<ResourceGroup> getGroups() {
        this.ensureLoaded();
        return this.groups;
    }

    public ResourceGroup getGroup(String groupName) {
        this.ensureLoaded();
        return this.map.get(groupName);
    }

    public String getDestination(String groupName, String source) {
        ResourceGroup list = this.getGroup(groupName);
        if (list != null) {
            return list.getDestination(source);
        }
        return null;
    }

    public String getSource(String groupName, String destination) {
        ResourceGroup list = this.getGroup(groupName);
        if (list != null) {
            return list.getSource(destination);
        }
        return null;
    }

    private void ensureLoaded() {
        if (this.groups != null && this.map != null) {
            return;
        }
        this.lazyLoad();
        if (this.groups == null) {
            this.groups = Collections.emptyList();
        }
        if (this.map == null) {
            this.map = Collections.emptyMap();
        }
    }

    private void lazyLoad() {
        if (this.implementation == null) {
            return;
        }
        Iterator it = DOMUtils.childElementIterByTag((Node)this.implementation.getDocumentElement(), (String)"resource-group");
        while (it.hasNext()) {
            this.createResourceGorup((Element)it.next());
        }
    }

    private void createResourceGorup(Element element) {
        ResourceGroup list = new ResourceGroup(element, this);
        if (this.groups == null) {
            this.groups = new ArrayList<ResourceGroup>();
        }
        this.groups.add(list);
        String type = list.getType();
        if (type != null) {
            if (this.map == null) {
                this.map = new HashMap<String, ResourceGroup>();
            }
            this.map.put(type, list);
        }
    }

    public static ResourceMappingManager createEmptyInstance(String applicationId) {
        return new ResourceMappingManager(applicationId);
    }

    public static ResourceMappingManager createInstance(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        ResourceMappingManager resourceMappingManager;
        if (builder == null) {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        try {
            Document document = builder.parse(stream);
            resourceMappingManager = new ResourceMappingManager(document);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        return resourceMappingManager;
    }

    public static ResourceMappingManager createInstance(URL url) throws ParserConfigurationException, SAXException, IOException {
        InputStream stream = url.openStream();
        return ResourceMappingManager.createInstance(stream);
    }

    public static ResourceMappingManager createInstance(Class<?> clazz, String name) throws ParserConfigurationException, SAXException, IOException {
        InputStream stream = clazz.getResourceAsStream(name);
        if (stream == null) {
            throw new FileNotFoundException();
        }
        return ResourceMappingManager.createInstance(stream);
    }
}

