/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.fishbone.structures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.xmind.core.IBoundary;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.ui.branch.IBranchHook;
import org.xmind.ui.mindmap.IBranchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FishboneBranchHook
implements IBranchHook,
ICoreEventListener,
FigureListener {
    private IBranchPart branch;
    private List<ICoreEventRegistration> topicListeners = new ArrayList<ICoreEventRegistration>();
    private Map<Object, List<ICoreEventRegistration>> rangeListeners = new HashMap<Object, List<ICoreEventRegistration>>();

    public void hook(IBranchPart branch) {
        this.branch = branch;
        branch.getFigure().addFigureListener((FigureListener)this);
        ITopic topic = branch.getTopic();
        if (topic instanceof ICoreEventSource) {
            ICoreEventSource source = (ICoreEventSource)topic;
            this.topicListeners.add(source.registerCoreEventListener("boundaryAdd", (ICoreEventListener)this));
            this.topicListeners.add(source.registerCoreEventListener("boundaryRemove", (ICoreEventListener)this));
            this.topicListeners.add(source.registerCoreEventListener("summaryAdd", (ICoreEventListener)this));
            this.topicListeners.add(source.registerCoreEventListener("summaryRemove", (ICoreEventListener)this));
            this.topicListeners.add(source.registerCoreEventListener("topicAdd", (ICoreEventListener)this));
            this.topicListeners.add(source.registerCoreEventListener("topicRemove", (ICoreEventListener)this));
        }
        for (IBoundary boundary : topic.getBoundaries()) {
            this.registerRangeListeners(boundary);
        }
        for (ISummary summary : topic.getSummaries()) {
            this.registerRangeListeners(summary);
        }
    }

    public void unhook(IBranchPart branch) {
        this.unregister(this.topicListeners);
        for (List<ICoreEventRegistration> regs : this.rangeListeners.values()) {
            this.unregister(regs);
        }
        branch.getFigure().removeFigureListener((FigureListener)this);
        this.updateSubBranches(branch);
    }

    private void unregister(List<ICoreEventRegistration> listeners) {
        for (ICoreEventRegistration reg : listeners) {
            reg.unregister();
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("boundaryAdd".equals(type) || "summaryAdd".equals(type)) {
            Object range = event.getTarget();
            this.registerRangeListeners(range);
            this.updateSubBranches(this.branch);
        } else if ("boundaryRemove".equals(type) || "summaryRemove".equals(type)) {
            Object range = event.getTarget();
            List<ICoreEventRegistration> list = this.rangeListeners.remove(range);
            if (list != null) {
                this.unregister(list);
            }
            this.updateSubBranches(this.branch);
        } else if ("range".equals(type)) {
            if (this.isHeadBranch(this.branch)) {
                this.branch.getFigure().invalidate();
                this.branch.update();
                this.updateSubBranches(this.branch);
            }
        } else if (("topicAdd".equals(type) || "topicRemove".equals(type)) && "attached".equals(event.getData())) {
            this.updateSubBranches(this.branch);
        }
    }

    private boolean isHeadBranch(IBranchPart branch) {
        IBranchPart parent = branch.getParentBranch();
        if (parent == null) {
            return true;
        }
        String parentPolicyId = parent.getBranchPolicyId();
        return !branch.getBranchPolicyId().equals(parentPolicyId);
    }

    private void registerRangeListeners(Object range) {
        if (range instanceof ICoreEventSource) {
            ICoreEventSource source = (ICoreEventSource)range;
            ArrayList<ICoreEventRegistration> list = new ArrayList<ICoreEventRegistration>();
            list.add(source.registerCoreEventListener("range", (ICoreEventListener)this));
            this.rangeListeners.put(range, list);
        }
    }

    public void figureMoved(IFigure source) {
        IDecoration decoration = ((IDecoratedFigure)this.branch.getFigure()).getDecoration();
        if (decoration != null) {
            decoration.invalidate();
        }
    }

    private void updateSubBranches(IBranchPart branch) {
        for (IBranchPart subBranch : branch.getSubBranches()) {
            this.flushChildStructureType(subBranch);
            subBranch.treeUpdate(false);
        }
    }

    private void flushChildStructureType(IBranchPart subBranch) {
        subBranch.getBranchPolicy().flushStructureCache(subBranch, false, true);
    }
}

