/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.fishbone.decorations;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.IPrecisionTransformer;
import org.xmind.gef.draw2d.geometry.PrecisionHorizontalFlipper;
import org.xmind.gef.draw2d.geometry.PrecisionLine;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractTopicDecoration;

public class FishheadTopicDecoration
extends AbstractTopicDecoration {
    private static final PrecisionPoint p1 = new PrecisionPoint();
    private static final PrecisionPoint p2 = new PrecisionPoint();
    private IPrecisionTransformer f = new PrecisionHorizontalFlipper();
    private static final float headGapScale = 0.1f;
    private static final float headConScale = 0.3f;
    private static final float headHorScale = 0.1f;
    private static final float headVerScale = 0.4f;

    public FishheadTopicDecoration(boolean rightHeaded) {
        this.f.setEnabled(rightHeaded);
    }

    protected void sketch(IFigure figure, Path shape, Rectangle box, int purpose) {
        Insets ins = figure.getInsets();
        Rectangle clientArea = box.getCropped(ins);
        this.f.setOrigin((double)box.x + (double)box.width * 0.5, (double)box.y + (double)box.height * 0.5);
        int right = box.right();
        int bottom = box.bottom();
        float x = (float)box.x + (float)clientArea.width * 0.3f;
        float y = (float)box.y + (float)box.height * 0.5f;
        this.f.tp((double)right, (double)box.y, p1);
        shape.moveTo((float)FishheadTopicDecoration.p1.x, (float)FishheadTopicDecoration.p1.y);
        this.f.tp((double)x, (double)box.y, p1);
        this.f.tp((double)box.x, (double)y, p2);
        shape.quadTo((float)FishheadTopicDecoration.p1.x, (float)FishheadTopicDecoration.p1.y, (float)FishheadTopicDecoration.p2.x, (float)FishheadTopicDecoration.p2.y);
        this.f.tp((double)x, (double)bottom, p1);
        this.f.tp((double)right, (double)bottom, p2);
        shape.quadTo((float)FishheadTopicDecoration.p1.x, (float)FishheadTopicDecoration.p1.y, (float)FishheadTopicDecoration.p2.x, (float)FishheadTopicDecoration.p2.y);
        shape.close();
    }

    public PrecisionPoint getAnchorLocation(IFigure figure, double refX, double refY, double expansion) {
        Insets ins = figure.getInsets();
        Rectangle box = figure.getBounds();
        this.f.setOrigin((double)box.x + (double)box.width * 0.5, (double)box.y + (double)box.height * 0.5);
        Rectangle clientArea = box.getCropped(ins);
        int right = box.right();
        int bottom = box.bottom();
        float cx = (float)box.x + (float)clientArea.width * 0.3f;
        float ey = (float)box.y + (float)box.height * 0.5f;
        Point center = box.getCenter();
        PrecisionLine line = new PrecisionLine(this.f.tp((double)center.x, (double)center.y, p1), this.f.tp(refX, refY, p2), PrecisionLine.LineType.Ray);
        PrecisionLine rightBorder = new PrecisionLine((double)right, (double)box.y, (double)right, (double)bottom, PrecisionLine.LineType.LineSegment);
        PrecisionPoint p = line.intersect(rightBorder);
        if (p != null) {
            return this.f.r(p);
        }
        PrecisionPoint[] ps = Geometry.intersectQuadBezier((PrecisionLine)line, (double)right, (double)box.y, (double)cx, (double)box.y, (double)box.x, (double)ey);
        if (ps.length > 0) {
            return this.f.r(ps[0]);
        }
        ps = Geometry.intersectQuadBezier((PrecisionLine)line, (double)box.x, (double)ey, (double)cx, (double)bottom, (double)right, (double)bottom);
        if (ps.length > 0) {
            return this.f.r(ps[0]);
        }
        return this.f.rp((double)box.x, (double)box.y);
    }

    public Insets getPreferredInsets(IFigure figure, int width, int height) {
        int v = (int)((float)height * 0.4f);
        int r = this.f.isEnabled() ? this.hor(this.getRightMargin(), width) : this.gap(this.getRightMargin());
        int l = this.f.isEnabled() ? this.gap(this.getLeftMargin()) : this.hor(this.getLeftMargin(), width);
        return new Insets(v + this.getTopMargin() + this.getLineWidth(), l + this.getLineWidth(), v + this.getBottomMargin() + this.getLineWidth(), r + this.getLineWidth());
    }

    private int hor(int margin, int wHint) {
        return (int)((float)wHint * 0.1f) + margin;
    }

    private int gap(int margin) {
        return (int)((float)margin * 0.1f);
    }
}

