/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.cathy.internal.Log;
import org.xmind.cathy.internal.actions.SimpleOpenAction;

public class Startup
implements IStartup {
    private IWorkbenchWindow primaryWindow;

    public void earlyStartup() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    Startup.this.hookWindow(window);
                }
            }
        });
    }

    private void hookWindow(IWorkbenchWindow window) {
        this.primaryWindow = window;
        Shell shell = window.getShell();
        if (shell != null && !shell.isDisposed()) {
            int hWnd = shell.handle;
            this.logPrimaryWindow(hWnd);
            shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellActivated(ShellEvent e) {
                    super.shellActivated(e);
                    Startup.this.checkLog();
                }
            });
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Log.get((String)".singleton").delete();
                    e.display.asyncExec(new Runnable(){

                        public void run() {
                            Startup.this.checkRemainingWindow();
                        }
                    });
                }
            });
        }
    }

    private void checkRemainingWindow() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        this.hookWindow(window);
    }

    private void logPrimaryWindow(int hWnd) {
        Log log = Log.get((String)".singleton");
        if (log.exists()) {
            log.delete();
        }
        log.getProperties().setProperty("PRIMARY_WINDOW", String.valueOf(hWnd));
        log.saveProperties();
    }

    private void checkLog() {
        Log log = Log.get((String)".opening");
        if (log.exists()) {
            String[] contents;
            boolean presentation = false;
            ArrayList<String> files = new ArrayList<String>();
            String[] stringArray = contents = log.getContents();
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if ("-p".equals(line)) {
                    presentation = true;
                } else {
                    files.add(line);
                }
                ++n2;
            }
            if (files.isEmpty()) {
                return;
            }
            for (String file : files) {
                this.open(file, presentation);
                if (!presentation) continue;
                presentation = false;
            }
            files.clear();
            log.delete();
        }
    }

    private void open(String path, boolean presentation) {
        File file = new File(path);
        if (file.isFile() && file.canRead()) {
            if (this.primaryWindow == null) {
                new SimpleOpenAction(path, presentation).run();
            } else {
                SimpleOpenAction.open((IWorkbenchWindow)this.primaryWindow, (String)path);
            }
        }
    }
}

