/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.util.Properties;
import org.eclipse.swt.internal.win32.OS;
import org.xmind.cathy.internal.IApplicationValidator;
import org.xmind.cathy.internal.Log;

public class ApplicationValidator
implements IApplicationValidator {
    public boolean shouldApplicationExitEarly() {
        Log log = Log.get((String)".singleton");
        if (!log.exists()) {
            return false;
        }
        Properties properties = log.getProperties();
        if (properties.isEmpty()) {
            return false;
        }
        int hWnd = this.getOpenedWindowHandle(properties);
        if (hWnd == 0 || !this.isValidWindow(hWnd)) {
            return false;
        }
        this.notifyOpenedWindow(hWnd);
        return true;
    }

    private boolean isValidWindow(int hWnd) {
        int length = OS.GetWindowTextLength((int)hWnd);
        return length > 0;
    }

    private int getOpenedWindowHandle(Properties properties) {
        String value = properties.getProperty("PRIMARY_WINDOW");
        if (value != null && !"".equals(value)) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    private void notifyOpenedWindow(int hWnd) {
        OS.SetForegroundWindow((int)hWnd);
        OS.SetFocus((int)hWnd);
    }
}

