/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.tree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.xmind.gef.AbstractViewer;
import org.xmind.gef.GEF;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tree.ITreePart;
import org.xmind.gef.tree.ITreeRootPart;
import org.xmind.gef.tree.ITreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeViewer
extends AbstractViewer
implements ITreeViewer {
    private boolean schedulingRedraw = false;

    @Override
    public Tree getTree() {
        return (Tree)this.getControl();
    }

    @Override
    protected void revealParts(List<? extends IPart> parts) {
        for (IPart iPart : parts) {
            ITreePart tp;
            if (!(iPart instanceof ITreePart) || !iPart.getStatus().isActive() || !((tp = (ITreePart)iPart).getWidget() instanceof TreeItem)) continue;
            TreeItem item = (TreeItem)tp.getWidget();
            this.ensureVisible(item);
            this.getTree().showItem(item);
        }
    }

    protected void ensureVisible(TreeItem item) {
        TreeItem parentItem = item.getParentItem();
        while (parentItem != null) {
            parentItem.setExpanded(true);
            parentItem = parentItem.getParentItem();
        }
    }

    @Override
    protected Control internalCreateControl(Composite parent, int style) {
        Tree tree = new Tree(parent, style);
        tree.setHeaderVisible(this.getProperties().getBoolean("PROP_HEADER_VISIBLE", true));
        tree.setLinesVisible(this.getProperties().getBoolean("PROP_LINES_VISIBLE", true));
        return tree;
    }

    @Override
    protected void hookControl(Control control) {
        super.hookControl(control);
        control.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeViewer.this.updateSelection();
            }
        });
        ((ITreeRootPart)this.getRootPart()).setWidget((Widget)control);
    }

    protected void updateSelection() {
        TreeItem[] selectedItems = this.getTree().getSelection();
        ArrayList<IPart> selectedParts = new ArrayList<IPart>(selectedItems.length);
        TreeItem[] treeItemArray = selectedItems;
        int n = selectedItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (data instanceof IPart) {
                selectedParts.add((IPart)data);
            }
            ++n2;
        }
        this.getSelectionSupport().setSelection((ISelection)new StructuredSelection(selectedParts), true);
    }

    @Override
    public void inputChanged(Object oldInput, Object newInput) {
        Control c = this.getControl();
        if (c != null && !c.isDisposed()) {
            c.setRedraw(false);
        }
        super.inputChanged(oldInput, newInput);
        if (c != null && !c.isDisposed()) {
            c.setRedraw(true);
        }
    }

    @Override
    public void scheduleRedraw() {
        if (GEF.IS_CARBON) {
            return;
        }
        Control c = this.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        if (this.schedulingRedraw) {
            return;
        }
        this.schedulingRedraw = true;
        c.setRedraw(false);
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                Control c = TreeViewer.this.getControl();
                if (c != null && !c.isDisposed()) {
                    c.setRedraw(true);
                }
                TreeViewer.this.schedulingRedraw = false;
            }
        });
    }
}

