/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.tool;

import org.xmind.gef.Request;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.tool.GraphicalTool;
import org.xmind.gef.tool.ISourceTool;
import org.xmind.gef.tool.ITool;

public abstract class EditTool
extends GraphicalTool
implements ISourceTool {
    private IGraphicalEditPart source;

    public IGraphicalEditPart getSource() {
        return this.source;
    }

    public void setSource(IGraphicalEditPart source) {
        this.source = source;
    }

    protected void onActivated(ITool prevTool) {
        super.onActivated(prevTool);
        this.refreshStatus();
        if (this.getSource() != null && !this.startEditing(this.getSource())) {
            this.changeActiveTool("default tool");
            return;
        }
    }

    protected void refreshStatus() {
        this.getStatus().setStatus(4, false);
        this.getStatus().setStatus(8, false);
        this.getStatus().setStatus(2, false);
    }

    protected boolean startEditing(IGraphicalEditPart source) {
        return false;
    }

    protected void cancelEditing() {
        this.changeActiveTool("default tool");
    }

    protected void finishEditing() {
        this.changeActiveTool("default tool");
    }

    protected boolean isViewRequest(String reqType) {
        String role = this.getDomain().getPartRoles().getRole(reqType);
        return this.isViewRole(role);
    }

    protected boolean isViewRole(String role) {
        return "selectable role".equals(role) || "scalable role".equals(role);
    }

    protected void handleSingleRequest(Request request) {
        if (request.getTargetViewer() == null || request.getTargetViewer() != this.getTargetViewer()) {
            super.handleSingleRequest(request);
            return;
        }
        String requestType = request.getType();
        if ("edit".equals(requestType)) {
            return;
        }
        if ("select all".equals(requestType)) {
            this.selectAll();
        } else if ("copy".equals(requestType)) {
            this.copy();
        } else if ("cut".equals(requestType)) {
            this.cut();
        } else if ("paste".equals(requestType)) {
            this.paste();
        } else if ("delete".equals(requestType)) {
            this.delete();
        } else if ("cancel".equals(requestType)) {
            this.cancelEditing();
        } else if ("finish".equals(requestType)) {
            this.finishEditing();
        } else if ("redo".equals(requestType)) {
            if (this.canRedo()) {
                this.redo();
            }
        } else if ("undo".equals(requestType)) {
            if (this.canUndo()) {
                this.undo();
            }
        } else if (this.isViewRequest(requestType)) {
            ITool defaultTool = this.getDomain().getDefaultTool();
            if (defaultTool != null) {
                defaultTool.handleRequest(request);
            }
        } else {
            this.finishEditing();
            ITool activeTool = this.getDomain().getActiveTool();
            if (activeTool != this) {
                activeTool.handleRequest(request);
            }
        }
    }

    protected void internalHandleRequest(Request request) {
        super.handleSingleRequest(request);
    }

    protected void selectAll() {
    }

    protected void copy() {
    }

    protected void cut() {
    }

    protected void paste() {
    }

    protected void delete() {
    }

    protected void undo() {
    }

    protected void redo() {
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }

    protected boolean handleMouseDown(MouseEvent me) {
        if (this.shouldFinishOnMouseDown(me)) {
            this.finishEditing();
            ITool activeTool = this.getDomain().getActiveTool();
            if (activeTool != this) {
                activeTool.mouseDown(me, this.getTargetViewer());
            }
            return true;
        }
        return super.handleMouseDown(me);
    }

    protected boolean shouldFinishOnMouseDown(MouseEvent me) {
        return me.target != this.getSource();
    }

    protected boolean handleKeyUp(KeyEvent ke) {
        if (this.shouldFinish(ke)) {
            this.finishEditing();
            return true;
        }
        if (this.shouldCancel(ke)) {
            this.cancelEditing();
            return true;
        }
        return super.handleKeyUp(ke);
    }

    protected abstract boolean shouldCancel(KeyEvent var1);

    protected abstract boolean shouldFinish(KeyEvent var1);

    protected boolean handleMouseEntered(MouseEvent me) {
        if (me.target.hasRole("selectable role")) {
            this.getTargetViewer().setPreselected(me.target);
        }
        return super.handleMouseEntered(me);
    }
}

