/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.part;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.IDecorator;
import org.xmind.gef.IViewer;
import org.xmind.gef.NullDecorator;
import org.xmind.gef.draw2d.IUseTransparency;
import org.xmind.gef.part.EditPart;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;

public abstract class GraphicalEditPart
extends EditPart
implements IGraphicalEditPart {
    private IFigure figure = null;
    private boolean decoratorActivated = false;
    private IDecorator decorator = null;

    public IFigure getFigure() {
        if (this.figure == null) {
            this.figure = this.createFigure();
        }
        return this.figure;
    }

    protected boolean hasFigure() {
        return this.figure != null;
    }

    public IFigure getContentPane() {
        return this.getFigure();
    }

    protected void initFigure(IFigure figure) {
        LayoutManager layout = this.createLayoutManager();
        if (layout != null) {
            this.getContentPane().setLayoutManager(layout);
        }
        this.getDecorator().activate(this, figure);
    }

    protected LayoutManager createLayoutManager() {
        return null;
    }

    protected abstract IFigure createFigure();

    protected void addChildView(IPart child, int index) {
        this.getContentPane().add(((IGraphicalPart)child).getFigure(), index);
    }

    protected void removeChildView(IPart child) {
        this.getContentPane().remove(((IGraphicalPart)child).getFigure());
    }

    public IDecorator getDecorator() {
        if (this.decorator == null) {
            return NullDecorator.getInstance();
        }
        return this.decorator;
    }

    public void setDecorator(IDecorator decorator) {
        this.decorator = decorator;
    }

    protected void onDeactivated() {
        super.onDeactivated();
        if (this.figure != null && this.decoratorActivated) {
            this.getDecorator().deactivate(this, this.figure);
            this.decoratorActivated = false;
        }
    }

    protected void updateView() {
        super.updateView();
        if (this.getFigure() != null) {
            if (!this.decoratorActivated) {
                this.initFigure(this.getFigure());
                this.decoratorActivated = true;
            }
            this.getDecorator().decorate(this, this.getFigure());
        }
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.getFigure() != null) {
            if (!this.decoratorActivated) {
                this.initFigure(this.getFigure());
                this.decoratorActivated = true;
            }
            this.getDecorator().decorateChildren(this, this.getFigure());
        }
    }

    public Object getAdapter(Class adapter) {
        IFigure f;
        if (adapter == IFigure.class) {
            return this.getFigure();
        }
        if (adapter == IUseTransparency.class && (f = this.getFigure()) instanceof IUseTransparency) {
            return (IUseTransparency)f;
        }
        if (adapter == IDecorator.class) {
            return this.getDecorator();
        }
        return super.getAdapter(adapter);
    }

    public IPart findAt(Point position) {
        IPart ret = this.findChildAt(position);
        if (ret != null) {
            return ret;
        }
        if (this.containsPoint(position)) {
            return this;
        }
        return null;
    }

    protected IPart findChildAt(Point position) {
        List<IPart> children = this.getChildren();
        int i = children.size() - 1;
        while (i >= 0) {
            IPart child = children.get(i);
            IPart ret = this.findChildAt(child, position);
            if (ret != null) {
                return ret;
            }
            --i;
        }
        return null;
    }

    protected IPart findChildAt(IPart child, Point position) {
        if (child instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)child).findAt(position);
        }
        return null;
    }

    public IFigure findTooltipAt(Point position) {
        if (this.containsPoint(position)) {
            return this.getFigure().getToolTip();
        }
        return null;
    }

    public boolean containsPoint(Point position) {
        return this.getFigure().isShowing() && this.getFigure().containsPoint(position);
    }

    public Cursor getCursor(Point pos) {
        return null;
    }

    public void updateToolTip() {
        IFigure fig = this.getFigure();
        if (fig != null) {
            fig.setToolTip(this.createToolTip());
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (!GraphicalEditPart.this.getStatus().isActive()) {
                        return;
                    }
                    IViewer viewer = GraphicalEditPart.this.getSite().getViewer();
                    if (viewer == null || viewer.getControl().isDisposed()) {
                        return;
                    }
                    viewer.updateToolTip();
                }
            });
        }
    }

    protected IFigure createToolTip() {
        return null;
    }
}

