/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.internal.image;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.xmind.gef.GEF;
import org.xmind.gef.image.ImageWriter;
import org.xmind.gef.internal.image.ImageConverter;

public class SWTImageWriter
extends ImageWriter {
    private int format;

    public SWTImageWriter(Image image, int format, OutputStream output) {
        super(image, output);
        this.format = format;
    }

    public SWTImageWriter(ImageData[] imageData, int format, OutputStream output) {
        super(imageData, output);
        this.format = format;
    }

    public int getFormat() {
        return this.format;
    }

    public void write(IProgressMonitor monitor) throws IOException {
        ImageData[] data = this.getCompatibleImageData();
        ImageLoader loader = new ImageLoader();
        loader.data = data;
        try {
            loader.save(this.getOutput(), this.getFormat());
        }
        catch (Throwable e) {
            throw new IOException(e.getMessage());
        }
    }

    protected ImageData[] getCompatibleImageData() {
        ImageData[] oldData = this.getImageData();
        return SWTImageWriter.needsDepthConvertion(this.getFormat()) ? this.convertTo256Colors(oldData) : oldData;
    }

    protected ImageData[] convertTo256Colors(ImageData[] imageData) {
        ImageData[] newImageData = new ImageData[imageData.length];
        int i = 0;
        while (i < imageData.length) {
            newImageData[i] = ImageConverter.converTo256Colors(imageData[i]);
            ++i;
        }
        return newImageData;
    }

    private static boolean needsDepthConvertion(int format) {
        return format == 2 || format == 0 && GEF.IS_CARBON;
    }
}

