/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.image;

import java.io.OutputStream;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.xmind.gef.image.ExportAreaProvider;
import org.xmind.gef.image.FigureImageDescriptor;
import org.xmind.gef.image.IExportAreaProvider;
import org.xmind.gef.image.ImageWriter;
import org.xmind.gef.internal.image.ConstrainedExportAreaProvider;
import org.xmind.gef.internal.image.FittedExportAreaProvider;
import org.xmind.gef.internal.image.SWTImageWriter;
import org.xmind.gef.internal.image.StretchedExportAreaProvider;

public class ImageExportUtils {
    public static IExportAreaProvider createExportAreaProvider(IFigure figure) {
        return ImageExportUtils.createExportAreaProvider(figure, null, 0, -1, -1, null);
    }

    public static IExportAreaProvider createExportAreaProvider(IFigure figure, Insets margins) {
        return ImageExportUtils.createExportAreaProvider(figure, null, 0, -1, -1, margins);
    }

    public static IExportAreaProvider createExportAreaProvider(IFigure figure, int resizeStrategy, int wHint, int hHint) {
        return ImageExportUtils.createExportAreaProvider(figure, null, resizeStrategy, wHint, hHint, null);
    }

    public static IExportAreaProvider createExportAreaProvider(IFigure figure, int resizeStrategy, int wHint, int hHint, Insets margins) {
        return ImageExportUtils.createExportAreaProvider(figure, null, resizeStrategy, wHint, hHint, margins);
    }

    public static IExportAreaProvider createExportAreaProvider(IFigure figure, Rectangle sourceArea) {
        return ImageExportUtils.createExportAreaProvider(figure, sourceArea, 0, -1, -1, null);
    }

    public static IExportAreaProvider createExportAreaProvider(IFigure figure, Rectangle sourceArea, Insets margins) {
        return ImageExportUtils.createExportAreaProvider(figure, sourceArea, 0, -1, -1, margins);
    }

    public static IExportAreaProvider createExportAreaProvider(IFigure figure, Rectangle sourceArea, int resizeStrategy, int constrainedWidth, int constrainedHeight, Insets margins) {
        if (resizeStrategy == 1) {
            return new StretchedExportAreaProvider(figure, sourceArea, constrainedWidth, constrainedHeight, margins);
        }
        if (resizeStrategy == 2) {
            return new FittedExportAreaProvider(figure, sourceArea, constrainedWidth, constrainedHeight, margins);
        }
        if (resizeStrategy == 3) {
            return new ConstrainedExportAreaProvider(figure, sourceArea, constrainedWidth, constrainedHeight, margins);
        }
        return new ExportAreaProvider(figure, sourceArea, constrainedWidth, constrainedHeight, margins);
    }

    public static ImageDescriptor createImageDescriptor(IFigure figure) {
        return FigureImageDescriptor.createFromFigure(figure, ImageExportUtils.createExportAreaProvider(figure, null, 0, -1, -1, null));
    }

    public static ImageDescriptor createImageDescriptor(IFigure figure, Insets margins) {
        return FigureImageDescriptor.createFromFigure(figure, ImageExportUtils.createExportAreaProvider(figure, null, 0, -1, -1, margins));
    }

    public static ImageDescriptor createImageDescriptor(IFigure figure, int resizeStrategy, int wHint, int hHint) {
        return FigureImageDescriptor.createFromFigure(figure, ImageExportUtils.createExportAreaProvider(figure, null, resizeStrategy, wHint, hHint, null));
    }

    public static ImageDescriptor createImageDescriptor(IFigure figure, int resizeStrategy, int wHint, int hHint, Insets margins) {
        return FigureImageDescriptor.createFromFigure(figure, ImageExportUtils.createExportAreaProvider(figure, null, resizeStrategy, wHint, hHint, margins));
    }

    public static ImageDescriptor createImageDescriptor(IFigure figure, Rectangle sourceArea) {
        return FigureImageDescriptor.createFromFigure(figure, ImageExportUtils.createExportAreaProvider(figure, sourceArea, 0, -1, -1, null));
    }

    public static ImageDescriptor createImageDescriptor(IFigure figure, Rectangle sourceArea, Insets margins) {
        return FigureImageDescriptor.createFromFigure(figure, ImageExportUtils.createExportAreaProvider(figure, sourceArea, 0, -1, -1, margins));
    }

    public static ImageDescriptor createImageDescriptor(IFigure figure, Rectangle sourceArea, int resizeStrategy, int constrainedWidth, int constrainedHeight, Insets margins) {
        return FigureImageDescriptor.createFromFigure(figure, ImageExportUtils.createExportAreaProvider(figure, sourceArea, resizeStrategy, constrainedWidth, constrainedHeight, margins));
    }

    public static ImageWriter createImageWriter(Image image, int format, OutputStream output) {
        return new SWTImageWriter(image, format, output);
    }

    public static ImageWriter createImageWriter(ImageData[] imageData, int format, OutputStream output) {
        return new SWTImageWriter(imageData, format, output);
    }
}

