/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.graphics;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.TextLayout;
import org.xmind.gef.draw2d.IUseTransparency;
import org.xmind.gef.draw2d.graphics.GradientPattern;

public class AlphaGraphics
extends Graphics
implements IUseTransparency {
    private Graphics delegate;
    private int alphaMask = 255;
    private int localAlpha;
    private GradientPattern localBgPattern;
    private GradientPattern localFgPattern;

    public AlphaGraphics(Graphics delegate) {
        this.delegate = delegate;
        delegate.pushState();
        this.localAlpha = delegate.getAlpha();
        delegate.setAlpha(this.getWorkingAlpha(this.localAlpha));
    }

    protected Graphics getDelegate() {
        return this.delegate;
    }

    public int getMainAlpha() {
        return this.alphaMask;
    }

    public void setMainAlpha(int alphaMask) {
        this.alphaMask = alphaMask;
    }

    public int getSubAlpha() {
        return this.getAlpha();
    }

    public void setSubAlpha(int alpha) {
        this.setAlpha(alpha);
    }

    public void setAlpha(int alpha) {
        this.localAlpha = alpha;
        this.delegate.setAlpha(this.getWorkingAlpha(alpha));
    }

    private int getWorkingAlpha(int alpha) {
        return alpha * this.getMainAlpha() / 255;
    }

    public int getAlpha() {
        return this.localAlpha;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (pattern instanceof GradientPattern) {
            GradientPattern gp = (GradientPattern)pattern;
            if (this.localBgPattern != null) {
                this.localBgPattern.dispose();
            }
            this.localBgPattern = new GradientPattern(gp.getDevice(), gp.x1, gp.y1, gp.x2, gp.y2, gp.color1, this.getWorkingAlpha(gp.alpha1), gp.color2, this.getWorkingAlpha(gp.alpha2));
            this.delegate.setBackgroundPattern((Pattern)this.localBgPattern);
        } else {
            this.delegate.setBackgroundPattern(pattern);
        }
    }

    public void setForegroundPattern(Pattern pattern) {
        if (pattern instanceof GradientPattern) {
            GradientPattern gp = (GradientPattern)pattern;
            if (this.localFgPattern != null) {
                this.localFgPattern.dispose();
            }
            this.localFgPattern = new GradientPattern(gp.getDevice(), gp.x1, gp.y1, gp.x2, gp.y2, gp.color1, this.getWorkingAlpha(gp.alpha1), gp.color2, this.getWorkingAlpha(gp.alpha2));
            this.delegate.setBackgroundPattern((Pattern)this.localFgPattern);
        } else {
            this.delegate.setForegroundPattern(pattern);
        }
    }

    public void dispose() {
        this.delegate.popState();
        if (this.localBgPattern != null) {
            this.localBgPattern.dispose();
            this.localBgPattern = null;
        }
        if (this.localFgPattern != null) {
            this.localFgPattern.dispose();
            this.localFgPattern = null;
        }
    }

    public void clipRect(Rectangle r) {
        this.delegate.clipRect(r);
    }

    public void drawArc(int x, int y, int w, int h, int offset, int length) {
        this.delegate.drawArc(x, y, w, h, offset, length);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.delegate.drawFocus(x, y, w, h);
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        this.delegate.drawImage(srcImage, x1, y1, w1, h1, x2, y2, w2, h2);
    }

    public void drawImage(Image srcImage, int x, int y) {
        this.delegate.drawImage(srcImage, x, y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.delegate.drawLine(x1, y1, x2, y2);
    }

    public void drawOval(int x, int y, int w, int h) {
        this.delegate.drawOval(x, y, w, h);
    }

    public void drawPath(Path path) {
        this.delegate.drawPath(path);
    }

    public void drawPoint(int x, int y) {
        this.delegate.drawPoint(x, y);
    }

    public void drawPolygon(int[] points) {
        this.delegate.drawPolygon(points);
    }

    public void drawPolygon(PointList points) {
        this.delegate.drawPolygon(points);
    }

    public void drawPolyline(int[] points) {
        this.delegate.drawPolyline(points);
    }

    public void drawPolyline(PointList points) {
        this.delegate.drawPolyline(points);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.delegate.drawRectangle(x, y, width, height);
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.delegate.drawRoundRectangle(r, arcWidth, arcHeight);
    }

    public void drawString(String s, int x, int y) {
        this.delegate.drawString(s, x, y);
    }

    public void drawText(String s, int x, int y, int style) {
        this.delegate.drawText(s, x, y, style);
    }

    public void drawText(String s, int x, int y) {
        this.delegate.drawText(s, x, y);
    }

    public void drawTextLayout(TextLayout layout, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.delegate.drawTextLayout(layout, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public void fillArc(int x, int y, int w, int h, int offset, int length) {
        this.delegate.fillArc(x, y, w, h, offset, length);
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.delegate.fillGradient(x, y, w, h, vertical);
    }

    public void fillOval(int x, int y, int w, int h) {
        this.delegate.fillOval(x, y, w, h);
    }

    public void fillPath(Path path) {
        this.delegate.fillPath(path);
    }

    public void fillPolygon(int[] points) {
        this.delegate.fillPolygon(points);
    }

    public void fillPolygon(PointList points) {
        this.delegate.fillPolygon(points);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.delegate.fillRectangle(x, y, width, height);
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.delegate.fillRoundRectangle(r, arcWidth, arcHeight);
    }

    public void fillString(String s, int x, int y) {
        this.delegate.fillString(s, x, y);
    }

    public void fillText(String s, int x, int y) {
        this.delegate.fillText(s, x, y);
    }

    public double getAbsoluteScale() {
        return this.delegate.getAbsoluteScale();
    }

    public int getAntialias() {
        return this.delegate.getAntialias();
    }

    public Color getBackgroundColor() {
        return this.delegate.getBackgroundColor();
    }

    public Rectangle getClip(Rectangle rect) {
        return this.delegate.getClip(rect);
    }

    public int getFillRule() {
        return this.delegate.getFillRule();
    }

    public Font getFont() {
        return this.delegate.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this.delegate.getFontMetrics();
    }

    public Color getForegroundColor() {
        return this.delegate.getForegroundColor();
    }

    public int getInterpolation() {
        return this.delegate.getInterpolation();
    }

    public int getLineCap() {
        return this.delegate.getLineCap();
    }

    public int getLineJoin() {
        return this.delegate.getLineJoin();
    }

    public int getLineStyle() {
        return this.delegate.getLineStyle();
    }

    public int getLineWidth() {
        return this.delegate.getLineWidth();
    }

    public int getTextAntialias() {
        return this.delegate.getTextAntialias();
    }

    public boolean getXORMode() {
        return this.delegate.getXORMode();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void popState() {
        this.delegate.popState();
    }

    public void pushState() {
        this.delegate.pushState();
    }

    public void restoreState() {
        this.delegate.restoreState();
    }

    public void rotate(float degrees) {
        this.delegate.rotate(degrees);
    }

    public void scale(double amount) {
        this.delegate.scale(amount);
    }

    public void scale(float horizontal, float vertical) {
        this.delegate.scale(horizontal, vertical);
    }

    public void setAntialias(int value) {
        this.delegate.setAntialias(value);
    }

    public void setBackgroundColor(Color rgb) {
        this.delegate.setBackgroundColor(rgb);
    }

    public void setClip(Path path) {
        this.delegate.setClip(path);
    }

    public void setClip(Rectangle r) {
        this.delegate.setClip(r);
    }

    public void setFillRule(int rule) {
        this.delegate.setFillRule(rule);
    }

    public void setFont(Font f) {
        this.delegate.setFont(f);
    }

    public void setForegroundColor(Color rgb) {
        this.delegate.setForegroundColor(rgb);
    }

    public void setInterpolation(int interpolation) {
        this.delegate.setInterpolation(interpolation);
    }

    public void setLineCap(int cap) {
        this.delegate.setLineCap(cap);
    }

    public void setLineDash(int[] dash) {
        this.delegate.setLineDash(dash);
    }

    public void setLineJoin(int join) {
        this.delegate.setLineJoin(join);
    }

    public void setLineStyle(int style) {
        this.delegate.setLineStyle(style);
    }

    public void setLineWidth(int width) {
        this.delegate.setLineWidth(width);
    }

    public void setTextAntialias(int value) {
        this.delegate.setTextAntialias(value);
    }

    public void setXORMode(boolean b) {
        this.delegate.setXORMode(b);
    }

    public void shear(float horz, float vert) {
        this.delegate.shear(horz, vert);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void translate(float dx, float dy) {
        this.delegate.translate(dx, dy);
    }

    public void translate(int dx, int dy) {
        this.delegate.translate(dx, dy);
    }
}

