/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.geometry.Geometry;

public class ReferencedLayoutData {
    private Point reference;
    private Map<Object, Rectangle> contents = new HashMap<Object, Rectangle>();
    private Rectangle clientArea = null;

    public ReferencedLayoutData() {
        this.reference = new Point();
    }

    public ReferencedLayoutData(Point reference) {
        this.reference = new Point(reference);
    }

    public Point getReference() {
        return this.reference;
    }

    public void put(IFigure figure, Rectangle preferredBounds) {
        if (figure == null || preferredBounds == null) {
            return;
        }
        this.contents.put(figure, preferredBounds);
        this.clientArea = Geometry.union(this.clientArea, preferredBounds);
    }

    public void add(Rectangle blankArea) {
        if (blankArea == null) {
            return;
        }
        this.clientArea = Geometry.union(this.clientArea, blankArea);
    }

    public Rectangle get(Object figure) {
        return this.contents.get(figure);
    }

    public void addMargins(Insets margin) {
        if (this.clientArea == null) {
            this.clientArea = Geometry.getExpanded(this.reference.x, this.reference.y, margin);
        } else {
            this.clientArea.expand(margin);
        }
    }

    public void addMargins(int top, int left, int bottom, int right) {
        if (this.clientArea == null) {
            this.clientArea = new Rectangle(this.reference.x - left, this.reference.y - top, this.reference.x + left + right, this.reference.y + top + bottom);
        } else {
            this.clientArea.x -= left;
            this.clientArea.y -= top;
            this.clientArea.width += left + right;
            this.clientArea.height += top + bottom;
        }
    }

    public void translate(int dx, int dy) {
        for (Rectangle r : this.contents.values()) {
            r.translate(dx, dy);
        }
        if (this.clientArea != null) {
            this.clientArea.translate(dx, dy);
        }
    }

    public Rectangle getClientArea() {
        return this.clientArea;
    }

    public Rectangle getCheckedClientArea() {
        return this.clientArea == null ? this.createInitBounds() : this.clientArea;
    }

    public Rectangle createInitBounds(Point ref) {
        return new Rectangle(ref.x, ref.y, 0, 0);
    }

    public Rectangle createInitBounds() {
        return this.createInitBounds(this.reference);
    }
}

