/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IAnchorListener;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;

public abstract class AbstractAnchor
implements IAnchor,
FigureListener {
    private List<IAnchorListener> listeners = null;
    private IFigure owner;

    protected AbstractAnchor() {
    }

    public AbstractAnchor(IFigure owner) {
        this.setOwner(owner);
    }

    protected void setOwner(IFigure owner) {
        if (owner == this.owner) {
            return;
        }
        if (this.getOwner() != null && this.hasAnchorListener()) {
            this.getOwner().removeFigureListener((FigureListener)this);
        }
        this.owner = owner;
        if (this.getOwner() != null && this.hasAnchorListener()) {
            this.getOwner().addFigureListener((FigureListener)this);
        }
    }

    public PrecisionPoint getLocation(int orientation, double expansion) {
        switch (orientation) {
            case 8: {
                return this.getWest(expansion);
            }
            case 4: {
                return this.getSouth(expansion);
            }
            case 1: {
                return this.getNorth(expansion);
            }
        }
        return this.getEast(expansion);
    }

    protected PrecisionPoint getEast(double expansion) {
        PrecisionPoint ref = this.getReferencePoint();
        return this.getLocation(ref.x + 100.0, ref.y, expansion);
    }

    protected PrecisionPoint getNorth(double expansion) {
        PrecisionPoint ref = this.getReferencePoint();
        return this.getLocation(ref.x, ref.y - 100.0, expansion);
    }

    protected PrecisionPoint getSouth(double expansion) {
        PrecisionPoint ref = this.getReferencePoint();
        return this.getLocation(ref.x, ref.y + 100.0, expansion);
    }

    protected PrecisionPoint getWest(double expansion) {
        PrecisionPoint ref = this.getReferencePoint();
        return this.getLocation(ref.x - 100.0, ref.y, expansion);
    }

    public PrecisionPoint getLocation(PrecisionPoint reference, double expansion) {
        return this.getLocation(reference.x, reference.y, expansion);
    }

    public void addAnchorListener(IAnchorListener listener) {
        boolean hadListener = this.hasAnchorListener();
        if (this.listeners == null) {
            this.listeners = new ArrayList<IAnchorListener>();
        }
        this.listeners.add(listener);
        if (!hadListener && this.hasAnchorListener() && this.getOwner() != null) {
            this.getOwner().addFigureListener((FigureListener)this);
        }
    }

    public IFigure getOwner() {
        return this.owner;
    }

    public PrecisionPoint getReferencePoint() {
        if (this.getOwner() == null) {
            return new PrecisionPoint();
        }
        if (this.getOwner() instanceof IReferencedFigure) {
            return new PrecisionPoint(((IReferencedFigure)this.getOwner()).getReference());
        }
        Point ref = this.getOwner().getBounds().getCenter();
        this.getOwner().translateToAbsolute((Translatable)ref);
        return new PrecisionPoint(ref);
    }

    public void removeAnchorListener(IAnchorListener listener) {
        if (this.listeners == null) {
            return;
        }
        boolean hadListener = this.hasAnchorListener();
        this.listeners.remove(listener);
        if (hadListener && !this.hasAnchorListener() && this.getOwner() != null) {
            this.getOwner().removeFigureListener((FigureListener)this);
        }
    }

    public void figureMoved(IFigure source) {
        this.fireAnchorMoved();
    }

    protected void fireAnchorMoved() {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IAnchorListener)listener).anchorMoved(this);
            ++n2;
        }
    }

    protected boolean hasAnchorListener() {
        return this.listeners != null && !this.listeners.isEmpty();
    }
}

