/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.xmind.gef.EditDomain;
import org.xmind.gef.ISelectionSupport;
import org.xmind.gef.IViewer;
import org.xmind.gef.acc.AccessibleRegistry;
import org.xmind.gef.acc.IAccessible;
import org.xmind.gef.dnd.IDndSupport;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.part.PartRegistry;
import org.xmind.gef.service.IViewerService;
import org.xmind.gef.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractViewer
extends Viewer
implements IViewer {
    private static final List<IPart> EMPTY_PART_SELECTION = Collections.emptyList();
    private Control control = null;
    private IRootPart rootPart = null;
    private IPartFactory partFactory = null;
    private PartRegistry partRegistry = null;
    private EditDomain domain = null;
    private Object input = null;
    private List<ViewerFilter> filters = null;
    private ViewerSorter sorter = null;
    private ISelectionSupport selectionSupport = null;
    private Properties properties = null;
    private IDndSupport dndSupport = null;
    private AccessibleRegistry accRegistry = null;
    private IPart preSelected = null;
    private IPart focused = null;
    private List<ISelectionChangedListener> preSelectionChangedListeners = null;
    private Map<Class<? extends IViewerService>, IViewerService> serviceRegistry = null;

    protected AbstractViewer() {
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Control.class || adapter == Widget.class) {
            return this.getControl();
        }
        if (adapter == IRootPart.class) {
            return this.getRootPart();
        }
        if (adapter == IPartFactory.class) {
            return this.getPartFactory();
        }
        if (adapter == PartRegistry.class) {
            return this.getPartRegistry();
        }
        if (adapter == EditDomain.class) {
            return this.getEditDomain();
        }
        if (adapter == ISelectionSupport.class) {
            return this.getSelectionSupport();
        }
        if (adapter == IDndSupport.class) {
            return this.getDndSupport();
        }
        if (adapter == Properties.class) {
            return this.getProperties();
        }
        return null;
    }

    public Control createControl(Composite parent) {
        return this.createControl(parent, 0);
    }

    public Control createControl(Composite parent, int style) {
        this.control = this.internalCreateControl(parent, style);
        Assert.isNotNull((Object)this.control);
        this.hookControl(this.control);
        return this.control;
    }

    protected abstract Control internalCreateControl(Composite var1, int var2);

    protected void hookControl(Control control) {
        IRootPart rootPart;
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractViewer.this.handleDispose(e);
            }
        });
        if (this.serviceRegistry != null) {
            for (IViewerService service : this.serviceRegistry.values()) {
                service.setControl(control);
            }
        }
        if ((rootPart = this.getRootPart()) != null) {
            rootPart.getStatus().activate();
        }
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public IRootPart getRootPart() {
        return this.rootPart;
    }

    @Override
    public void setRootPart(IRootPart rootPart) {
        Assert.isNotNull((Object)rootPart);
        IRootPart oldRootPart = this.rootPart;
        if (oldRootPart != null) {
            oldRootPart.getStatus().deactivate();
            oldRootPart.setViewer(null);
        }
        this.rootPart = rootPart;
        rootPart.setViewer(this);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            rootPart.getStatus().activate();
        }
    }

    @Override
    public IPartFactory getPartFactory() {
        return this.partFactory;
    }

    @Override
    public void setPartFactory(IPartFactory partFactory) {
        if (partFactory == this.partFactory) {
            return;
        }
        Assert.isNotNull((Object)partFactory);
        this.partFactory = partFactory;
        this.inputChanged(this.getInput(), this.getInput());
    }

    @Override
    public EditDomain getEditDomain() {
        return this.domain;
    }

    @Override
    public void setEditDomain(EditDomain domain) {
        this.domain = domain;
    }

    public Object getInput() {
        return this.input;
    }

    @Override
    public void setInput(Object input) {
        Object oldInput = this.input;
        this.input = input;
        this.inputChanged(input, oldInput);
    }

    protected void inputChanged(Object input, Object oldInput) {
        List<IViewerService> activeServices = this.getActiveServices();
        if (activeServices != null) {
            for (IViewerService service : activeServices) {
                service.setActive(false);
            }
        }
        super.inputChanged(input, oldInput);
        IRootPart rootPart = this.getRootPart();
        if (rootPart != null) {
            rootPart.setModel(input);
            rootPart.setContents(this.createContents(rootPart, input));
        }
        if (this.serviceRegistry != null) {
            for (IViewerService service : this.serviceRegistry.values()) {
                service.inputChanged(oldInput, input);
            }
        }
        if (activeServices != null) {
            for (IViewerService service : activeServices) {
                service.setActive(true);
            }
        }
    }

    protected IPart createContents(IRootPart root, Object input) {
        if (input == null || this.getPartFactory() == null) {
            return null;
        }
        return this.getPartFactory().createPart(root, input);
    }

    public boolean setFocus() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return false;
        }
        return this.getControl().setFocus();
    }

    protected void handleDispose(DisposeEvent e) {
        IRootPart rootPart;
        if (this.serviceRegistry != null) {
            for (IViewerService service : this.serviceRegistry.values()) {
                service.dispose();
            }
            this.serviceRegistry.clear();
            this.serviceRegistry = null;
        }
        if (this.preSelectionChangedListeners != null) {
            this.preSelectionChangedListeners.clear();
        }
        if ((rootPart = this.getRootPart()) != null) {
            rootPart.getStatus().deactivate();
        }
    }

    @Override
    public void addFilter(ViewerFilter filter) {
        if (filter == null) {
            return;
        }
        if (this.filters != null && this.filters.contains(filter)) {
            return;
        }
        if (this.filters == null) {
            this.filters = new ArrayList<ViewerFilter>();
        }
        this.filters.add(filter);
        this.refresh();
    }

    @Override
    public ViewerFilter[] getFilters() {
        return this.filters == null ? new ViewerFilter[]{} : this.filters.toArray(new ViewerFilter[this.filters.size()]);
    }

    @Override
    public ViewerSorter getSorter() {
        return this.sorter;
    }

    @Override
    public void removeFilter(ViewerFilter filter) {
        if (filter == null || this.filters == null || this.filters.isEmpty()) {
            return;
        }
        this.filters.remove(filter);
        this.refresh();
    }

    @Override
    public void setFilters(ViewerFilter[] filters) {
        if (this.isFiltersEqual(filters, this.getFilters())) {
            return;
        }
        this.filters = filters == null || filters.length == 0 ? null : new ArrayList<ViewerFilter>((Collection)Arrays.asList(filters));
        this.refresh();
    }

    protected boolean isFiltersEqual(ViewerFilter[] fs1, ViewerFilter[] fs2) {
        if (fs1 == null) {
            return fs2 == null || fs2.length == 0;
        }
        if (fs2 == null) {
            return fs1.length == 0;
        }
        return Arrays.equals(fs1, fs2);
    }

    @Override
    public void setSorter(ViewerSorter sorter) {
        if (sorter == this.sorter || sorter != null && sorter.equals(this.sorter)) {
            return;
        }
        this.sorter = sorter;
        this.refresh();
    }

    @Override
    public ISelectionSupport getSelectionSupport() {
        if (this.selectionSupport == null) {
            this.selectionSupport = this.createSelectionSupport();
        }
        return this.selectionSupport;
    }

    protected ISelectionSupport createSelectionSupport() {
        return new SelectionSupport();
    }

    public ISelection getSelection() {
        return this.getSelectionSupport().getModelSelection();
    }

    @Override
    public void setSelection(ISelection selection, boolean reveal) {
        this.getSelectionSupport().setSelection(selection, reveal);
    }

    @Override
    public void reveal(Object[] elements) {
        if (elements == null || elements.length == 0) {
            return;
        }
        ISelectionSupport sd = this.getSelectionSupport();
        if (sd != null) {
            ArrayList<IPart> parts = new ArrayList<IPart>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                IPart p = sd.findSelectablePart(element);
                if (p != null && !parts.contains(p)) {
                    parts.add(p);
                }
                ++n2;
            }
            if (!parts.isEmpty()) {
                this.revealParts(parts);
            }
        }
    }

    protected void revealParts(List<? extends IPart> parts) {
    }

    public void refresh() {
        IRootPart rootPart = this.getRootPart();
        if (rootPart != null && rootPart.getStatus().isActive()) {
            this.treeRefresh(rootPart);
        }
    }

    protected void treeRefresh(IPart parent) {
        for (IPart child : parent.getChildren()) {
            child.refresh();
            this.treeRefresh(child);
        }
    }

    @Override
    public void updateToolTip() {
    }

    @Override
    public PartRegistry getPartRegistry() {
        if (this.partRegistry == null) {
            this.partRegistry = new PartRegistry();
        }
        return this.partRegistry;
    }

    @Override
    public IPart findPart(Object element) {
        if (element instanceof IPart) {
            return (IPart)element;
        }
        if (this.partRegistry == null) {
            return null;
        }
        return this.partRegistry.getPartByModel(element);
    }

    @Override
    public IPart findPart(int x, int y) {
        return null;
    }

    protected void setPartRegistry(PartRegistry partRegistry) {
        this.partRegistry = partRegistry;
    }

    @Override
    public AccessibleRegistry getAccessibleRegistry() {
        if (this.accRegistry == null) {
            this.accRegistry = new AccessibleRegistry();
        }
        return this.accRegistry;
    }

    protected void setAccessibleRegistry(AccessibleRegistry accRegistry) {
        this.accRegistry = accRegistry;
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties(this);
        }
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public IDndSupport getDndSupport() {
        return this.dndSupport;
    }

    public void setDndSupport(IDndSupport dndSupport) {
        this.dndSupport = dndSupport;
    }

    @Override
    public void addPreSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.preSelectionChangedListeners == null) {
            this.preSelectionChangedListeners = new ArrayList<ISelectionChangedListener>();
        }
        this.preSelectionChangedListeners.add(listener);
    }

    @Override
    public void removePreSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.preSelectionChangedListeners == null) {
            return;
        }
        this.preSelectionChangedListeners.remove(listener);
        if (this.preSelectionChangedListeners.isEmpty()) {
            this.preSelectionChangedListeners = null;
        }
    }

    protected void firePreSelectionChanged() {
        if (this.preSelectionChangedListeners == null) {
            return;
        }
        ISelection selection = this.createPreSelection();
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] objectArray = this.preSelectionChangedListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionChangedListener)listener).selectionChanged(event);
            ++n2;
        }
    }

    private ISelection createPreSelection() {
        return this.getPreselected() == null ? StructuredSelection.EMPTY : new StructuredSelection(this.getPreselected());
    }

    @Override
    public Object getPreselected() {
        return this.preSelected;
    }

    @Override
    public IPart getPreselectedPart() {
        return this.getSelectionSupport().findSelectablePart(this.getPreselected());
    }

    @Override
    public void setPreselected(Object element) {
        IPart oldPreselected = this.preSelected;
        IPart newPreselected = this.getSelectionSupport().findSelectablePart(element);
        if (newPreselected == oldPreselected) {
            return;
        }
        this.preSelected = newPreselected;
        if (oldPreselected != null) {
            oldPreselected.getStatus().dePreSelect();
        }
        if (newPreselected != null) {
            newPreselected.getStatus().preSelect();
        }
        this.firePreSelectionChanged();
    }

    @Override
    public Object getFocused() {
        return this.focused;
    }

    @Override
    public IPart getFocusedPart() {
        return this.getSelectionSupport().findSelectablePart(this.getFocused());
    }

    @Override
    public void setFocused(Object element) {
        Control c;
        IPart oldFocused = this.focused;
        IPart newFocused = this.getSelectionSupport().findSelectablePart(element);
        if (newFocused == oldFocused) {
            return;
        }
        this.focused = newFocused;
        if (oldFocused != null) {
            oldFocused.getStatus().lostFocus();
        }
        if (newFocused != null) {
            newFocused.getStatus().setFocus();
        }
        if ((c = this.getControl()) != null && !c.isDisposed()) {
            IAccessible acc;
            if (this.focused != null) {
                this.focused.getStatus().setFocus();
                acc = (IAccessible)this.focused.getAdapter(IAccessible.class);
            } else {
                acc = null;
            }
            if (acc != null) {
                c.getAccessible().setFocus(acc.getAccessibleId());
            } else {
                c.getAccessible().setFocus(-1);
            }
        }
    }

    @Override
    public IViewerService getService(Class<? extends IViewerService> serviceType) {
        if (serviceType == null || this.serviceRegistry == null) {
            return null;
        }
        return this.serviceRegistry.get(serviceType);
    }

    @Override
    public boolean hasService(Class<? extends IViewerService> serviceType) {
        return serviceType != null && this.serviceRegistry != null && this.serviceRegistry.containsKey(serviceType);
    }

    public void installService(Class<? extends IViewerService> type, IViewerService service) {
        if (type == null || service == null) {
            return;
        }
        if (this.serviceRegistry == null) {
            this.serviceRegistry = new HashMap<Class<? extends IViewerService>, IViewerService>();
        }
        this.serviceRegistry.put(type, service);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            service.setControl(this.getControl());
        }
    }

    public void uninstallService(Class<? extends IViewerService> type) {
        if (type == null || this.serviceRegistry == null) {
            return;
        }
        IViewerService service = this.serviceRegistry.remove(type);
        if (service != null) {
            service.dispose();
        }
    }

    private List<IViewerService> getActiveServices() {
        if (this.serviceRegistry != null) {
            ArrayList<IViewerService> list = new ArrayList<IViewerService>();
            for (IViewerService service : this.serviceRegistry.values()) {
                if (!service.isActive()) continue;
                list.add(service);
            }
            return list;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SelectionSupport
    implements ISelectionSupport {
        private ArrayList<IPart> partSelection = null;
        private ITextSelection textSelection = null;

        protected SelectionSupport() {
        }

        @Override
        public List<IPart> getPartSelection() {
            return this.partSelection == null ? EMPTY_PART_SELECTION : this.partSelection;
        }

        protected boolean trimValidParts() {
            if (this.partSelection == null || this.partSelection.isEmpty()) {
                return false;
            }
            boolean changed = true;
            Iterator<IPart> it = this.partSelection.iterator();
            while (it.hasNext()) {
                IPart p = it.next();
                if (this.isPartSelected(p)) continue;
                changed = true;
                it.remove();
            }
            return changed;
        }

        protected boolean isPartSelected(IPart p) {
            return this.isSelectable(p) && p.getStatus().isSelected();
        }

        @Override
        public void appendSelection(Object element) {
            boolean changed = this.trimValidParts();
            if (changed |= this.internalAppendSelection(this.findSelectablePart(element))) {
                this.partSelectionChanged(this.getPartSelection(), true);
                this.notifyViewerSelectionChanged();
            }
        }

        @Override
        public void appendSelection(List<?> elements) {
            boolean changed = this.trimValidParts();
            if (changed |= this.internalAppendSelection(elements)) {
                this.partSelectionChanged(this.getPartSelection(), true);
                this.notifyViewerSelectionChanged();
            }
        }

        protected boolean internalAppendSelection(List<?> elements) {
            boolean changed = false;
            Object[] objectArray = elements.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                changed |= this.internalAppendSelection(this.findSelectablePart(element));
                ++n2;
            }
            return changed;
        }

        protected boolean internalAppendSelection(IPart p) {
            int selectionConstraint;
            if (p == null) {
                return false;
            }
            if (this.partSelection != null && this.partSelection.contains(p)) {
                return false;
            }
            if (this.partSelection == null) {
                this.partSelection = new ArrayList();
            } else if (this.partSelection.size() >= 1 && ((selectionConstraint = this.getSelectionConstraint()) & 4) == 0) {
                return false;
            }
            boolean appended = this.partSelection.add(p);
            if (appended) {
                this.setSelected(p);
            }
            return appended;
        }

        protected void setSelected(IPart p) {
            p.getStatus().select();
        }

        @Override
        public void deselect(Object element) {
            boolean changed = this.trimValidParts();
            if (changed |= this.internalDeselect(this.findSelectablePart(element), false)) {
                this.partSelectionChanged(this.getPartSelection(), true);
                this.notifyViewerSelectionChanged();
            }
        }

        protected boolean internalDeselect(IPart p, boolean force) {
            int selectionConstraint;
            if (p == null) {
                return false;
            }
            if (this.partSelection == null || !this.partSelection.contains(p)) {
                return false;
            }
            if (!force && this.partSelection.size() <= 1 && ((selectionConstraint = this.getSelectionConstraint()) & 1) == 0) {
                return false;
            }
            boolean deselected = this.partSelection.remove(p);
            if (deselected) {
                this.setDeselected(p);
            }
            return deselected;
        }

        protected void setDeselected(IPart p) {
            p.getStatus().deSelect();
        }

        @Override
        public void deselectAll(List<?> elements) {
            boolean changed = this.trimValidParts();
            if (changed |= this.internalDeselectAll(elements, false)) {
                this.partSelectionChanged(this.getPartSelection(), true);
                this.notifyViewerSelectionChanged();
            }
        }

        protected boolean internalDeselectAll(List<?> elements, boolean force) {
            boolean changed = false;
            Object[] objectArray = elements.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                changed |= this.internalDeselect(this.findSelectablePart(element), force);
                ++n2;
            }
            return changed;
        }

        @Override
        public void deselectAll() {
            boolean changed = this.trimValidParts();
            if (changed |= this.internalDeselectAll(false)) {
                this.partSelectionChanged(this.getPartSelection(), true);
                this.notifyViewerSelectionChanged();
            }
        }

        protected boolean internalDeselectAll(boolean force) {
            if (this.partSelection == null || this.partSelection.isEmpty()) {
                return false;
            }
            return this.internalDeselectAll(this.partSelection, force);
        }

        @Override
        public ISelection getModelSelection() {
            if (this.textSelection != null) {
                return this.textSelection;
            }
            if (this.partSelection == null) {
                return StructuredSelection.EMPTY;
            }
            if (this.usePartsInSelection()) {
                return new StructuredSelection(this.partSelection);
            }
            return new StructuredSelection(this.getModels(this.partSelection));
        }

        protected List<Object> getModels(List<IPart> parts) {
            ArrayList<Object> list = new ArrayList<Object>(parts.size());
            for (IPart p : parts) {
                Object model = this.getModel(p);
                if (model == null || list.contains(model)) continue;
                list.add(model);
            }
            return list;
        }

        protected Object getModel(IPart p) {
            if (p == null) {
                return null;
            }
            return p.getModel();
        }

        protected boolean usePartsInSelection() {
            return false;
        }

        @Override
        public void selectAll(List<?> elements) {
            boolean changed = this.trimValidParts();
            if (changed |= this.internalSelectAll(elements)) {
                this.partSelectionChanged(this.getPartSelection(), true);
                this.notifyViewerSelectionChanged();
            }
        }

        protected boolean internalSelectAll(List<?> elements) {
            boolean changed = this.internalDeselectAll(!elements.isEmpty());
            return changed |= this.internalAppendSelection(elements);
        }

        @Override
        public void selectAll() {
            boolean changed = this.trimValidParts();
            IRootPart rootPart = AbstractViewer.this.getRootPart();
            if (rootPart != null) {
                List<IPart> toSelect = this.collectAllSelectableParts(rootPart, new ArrayList<IPart>());
                changed |= this.internalSelectAll(toSelect);
            }
            if (changed) {
                this.partSelectionChanged(this.getPartSelection(), true);
                this.notifyViewerSelectionChanged();
            }
        }

        protected List<IPart> collectAllSelectableParts(IPart parent, List<IPart> toReturn) {
            if (parent != null) {
                for (IPart p : parent.getChildren()) {
                    if (!this.isSelectable(p)) continue;
                    toReturn.add(p);
                    this.collectAllSelectableParts(p, toReturn);
                }
            }
            return toReturn;
        }

        @Override
        public void selectSingle(Object element) {
            boolean changed = this.trimValidParts();
            changed |= this.internalDeselectAll(true);
            if (changed |= this.internalAppendSelection(this.findSelectablePart(element))) {
                this.partSelectionChanged(this.getPartSelection(), true);
                this.notifyViewerSelectionChanged();
            }
        }

        @Override
        public void setSelection(ISelection selection, boolean reveal) {
            IStructuredSelection ss;
            List<IPart> toSelect;
            boolean changed = this.trimValidParts();
            if (selection instanceof ITextSelection) {
                ITextSelection newTextSelection = (ITextSelection)selection;
                if (changed |= this.internalSetTextSelection(newTextSelection)) {
                    this.textSelectionChanged(newTextSelection, reveal);
                }
            } else if (selection instanceof IStructuredSelection && (changed |= this.internalSelectAll(toSelect = this.collectAllSelectableParts((ss = (IStructuredSelection)selection).toArray(), new ArrayList<IPart>(), reveal)))) {
                this.partSelectionChanged(this.getPartSelection(), reveal);
            }
            if (changed) {
                this.notifyViewerSelectionChanged();
            }
        }

        protected List<IPart> collectAllSelectableParts(Object[] elements, List<IPart> toReturn, boolean reveal) {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                IPart p = this.findSelectablePart(element);
                if (p != null && !toReturn.contains(p)) {
                    toReturn.add(p);
                }
                ++n2;
            }
            return toReturn;
        }

        protected void partSelectionChanged(List<? extends IPart> parts, boolean reveal) {
            if (reveal) {
                AbstractViewer.this.reveal(parts.toArray());
            }
        }

        protected boolean internalSetTextSelection(ITextSelection newTextSelection) {
            if (newTextSelection == this.textSelection || newTextSelection != null && newTextSelection.equals(this.textSelection)) {
                return false;
            }
            this.textSelection = newTextSelection;
            return true;
        }

        protected void textSelectionChanged(ITextSelection newTextSelection, boolean reveal) {
        }

        @Override
        public IPart findSelectablePart(Object element) {
            IPart p = AbstractViewer.this.findPart(element);
            if (p == null || !this.isSelectable(p)) {
                return null;
            }
            return p;
        }

        @Override
        public boolean isSelectable(IPart p) {
            return p != null && p.getStatus().isActive() && p.hasRole("selectable role");
        }

        protected void notifyViewerSelectionChanged() {
            AbstractViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)AbstractViewer.this, this.getModelSelection()));
            AbstractViewer.this.getControl().getAccessible().selectionChanged();
        }

        @Override
        public void refresh() {
            if (this.textSelection != null) {
                this.textSelectionChanged(this.textSelection, true);
                return;
            }
            if (this.partSelection != null) {
                this.refreshPartSelection(AbstractViewer.this.getRootPart(), this.partSelection);
            }
        }

        protected void refreshPartSelection(IPart parent, List<? extends IPart> selectedParts) {
            if (parent == null) {
                return;
            }
            for (IPart p : parent.getChildren()) {
                if (selectedParts.contains(p)) {
                    this.setSelected(p);
                } else {
                    this.setDeselected(p);
                }
                this.refreshPartSelection(p, selectedParts);
            }
        }

        protected int getSelectionConstraint() {
            Object value = AbstractViewer.this.getProperties().get("selection constraint");
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return 7;
        }
    }
}

