/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ImageButton
extends Viewer {
    private Object input = null;
    private ImageDescriptor normalImageDescriptor = null;
    private ImageDescriptor pressedImageDescriptor = null;
    private ImageDescriptor disabledImageDescriptor = null;
    private ImageDescriptor hoveredImageDescriptor = null;
    private Image normalImage = null;
    private Image pressedImage = null;
    private Image disabledImage = null;
    private Image hoveredImage = null;
    private Canvas canvas;
    private boolean pressed = false;
    private boolean hovered = false;
    private Point sourcePos = null;
    private List<IOpenListener> openListeners = null;
    private boolean check = false;
    private boolean filled = false;

    public ImageButton(Composite parent, int style) {
        this.canvas = new Canvas(parent, this.checkStyle(style) | 0x20000000){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                ImageButton.this.refresh();
            }
        };
        this.configureControl(parent, (Control)this.canvas);
        this.hookControl((Control)this.canvas);
    }

    private int checkStyle(int style) {
        this.check = (style & 0x20) != 0;
        this.filled = (style & 4) != 0;
        int mask = 124;
        return style &= ~mask;
    }

    protected void configureControl(Composite parent, Control control) {
        control.setBackground(parent.getBackground());
        ((Composite)control).setLayout((Layout)new ImageLayout());
    }

    protected void hookControl(Control control) {
        EventHandler eventHandler = new EventHandler();
        control.addListener(9, (Listener)eventHandler);
        control.addListener(12, (Listener)eventHandler);
        control.addListener(3, (Listener)eventHandler);
        control.addListener(4, (Listener)eventHandler);
        control.addListener(6, (Listener)eventHandler);
        control.addListener(7, (Listener)eventHandler);
        control.addListener(5, (Listener)eventHandler);
    }

    protected void handlePaint(Event event) {
        Image img = null;
        if (!this.isEnabled()) {
            img = this.getDisabledImage();
        }
        if (img == null) {
            if (this.hovered) {
                img = this.getHoveredImage();
            }
            if (img == null) {
                if (this.pressed) {
                    img = this.getPressedImage();
                }
                if (img == null) {
                    img = this.getNormalImage();
                }
                if (img == null) {
                    img = this.getDisabledImage();
                }
            }
        }
        if (img != null) {
            if (this.filled) {
                Rectangle r1 = img.getBounds();
                Rectangle r2 = this.canvas.getBounds();
                event.gc.drawImage(img, r1.x, r1.y, r1.width, r1.height, 0, 0, r2.width, r2.height);
            } else {
                event.gc.drawImage(img, 0, 0);
            }
        }
    }

    protected void handleDispose(Event event) {
        this.dispose();
    }

    protected void handleMouseDown(Event event) {
        if (this.isEnabled() && event.button == 1) {
            this.pressed = true;
            this.sourcePos = new Point(event.x, event.y);
            this.refresh();
        }
    }

    protected void handleMouseUp(Event event) {
        if (this.isEnabled()) {
            OpenEvent oe = null;
            if (this.pressed) {
                oe = new OpenEvent((Viewer)this, this.getSelection());
            }
            this.pressed = false;
            this.sourcePos = null;
            this.refresh();
            if (oe != null) {
                this.asyncFireOpen(oe);
            }
        }
    }

    protected void handleMouseEnter(Event event) {
        if (this.isEnabled()) {
            if (event.button == 1) {
                this.pressed = true;
                this.refresh();
            } else {
                this.hovered = true;
                this.refresh();
            }
        }
    }

    protected void handleMouseExit(Event event) {
        if (this.isEnabled()) {
            if (event.button == 1) {
                this.pressed = false;
                this.refresh();
            } else {
                this.hovered = false;
                this.refresh();
            }
        }
    }

    protected void handleMouseMove(Event event) {
        if (this.isEnabled() && this.sourcePos != null) {
            int x = event.x;
            int y = event.y;
            boolean prevInside = this.containsPoint(this.sourcePos);
            boolean currInside = this.containsPoint(x, y);
            if (prevInside && !currInside) {
                this.handleMouseExit(event);
            } else if (!prevInside && currInside) {
                this.handleMouseEnter(event);
            }
            this.sourcePos.x = x;
            this.sourcePos.y = y;
        }
    }

    protected boolean isEnabled() {
        return this.canvas != null && !this.canvas.isDisposed() && this.canvas.isEnabled();
    }

    private boolean containsPoint(Point p) {
        return this.getBounds().contains(p);
    }

    private boolean containsPoint(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    private Rectangle getBounds() {
        Rectangle bounds = this.canvas.getBounds();
        bounds.x = 0;
        bounds.y = 0;
        return bounds;
    }

    public Control getControl() {
        return this.canvas;
    }

    public ImageDescriptor getNormalImageDescriptor() {
        return this.normalImageDescriptor;
    }

    public ImageDescriptor getPressedImageDescriptor() {
        return this.pressedImageDescriptor;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return this.disabledImageDescriptor;
    }

    public ImageDescriptor getHoveredImageDescriptor() {
        return this.hoveredImageDescriptor;
    }

    public void setNormalImageDescriptor(ImageDescriptor normalImageDescriptor) {
        if (normalImageDescriptor == this.normalImageDescriptor) {
            return;
        }
        if (this.normalImage != null) {
            this.normalImage.dispose();
            this.normalImage = null;
        }
        this.normalImageDescriptor = normalImageDescriptor;
        this.refresh();
    }

    public void setPressedImageDescriptor(ImageDescriptor pressedImageDescriptor) {
        if (pressedImageDescriptor == this.pressedImageDescriptor) {
            return;
        }
        if (this.pressedImage != null) {
            this.pressedImage.dispose();
            this.pressedImage = null;
        }
        this.pressedImageDescriptor = pressedImageDescriptor;
        this.refresh();
    }

    public void setDisabledImageDescriptor(ImageDescriptor disabledImageDescriptor) {
        if (disabledImageDescriptor == this.disabledImageDescriptor) {
            return;
        }
        if (this.disabledImage != null) {
            this.disabledImage.dispose();
            this.disabledImage = null;
        }
        this.disabledImageDescriptor = disabledImageDescriptor;
        this.refresh();
    }

    public void setHoveredImageDescriptor(ImageDescriptor hoveredImageDescriptor) {
        if (hoveredImageDescriptor == this.hoveredImageDescriptor) {
            return;
        }
        if (this.hoveredImage != null) {
            this.hoveredImage.dispose();
            this.hoveredImage = null;
        }
        this.hoveredImageDescriptor = hoveredImageDescriptor;
        this.refresh();
    }

    public void refresh() {
        if (!this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    protected Image getNormalImage() {
        if (this.normalImage == null && this.normalImageDescriptor != null) {
            this.normalImage = this.normalImageDescriptor.createImage(false);
        }
        return this.normalImage;
    }

    protected Image getPressedImage() {
        if (this.pressedImage == null && this.pressedImageDescriptor != null) {
            this.pressedImage = this.pressedImageDescriptor.createImage(false);
        }
        return this.pressedImage;
    }

    protected Image getDisabledImage() {
        if (this.disabledImage == null && this.disabledImageDescriptor != null) {
            this.disabledImage = this.disabledImageDescriptor.createImage(false);
        }
        return this.disabledImage;
    }

    protected Image getHoveredImage() {
        if (this.hoveredImage == null && this.hoveredImageDescriptor != null) {
            this.hoveredImage = this.hoveredImageDescriptor.createImage(false);
        }
        return this.hoveredImage;
    }

    public void addOpenListener(IOpenListener listener) {
        if (this.openListeners == null) {
            this.openListeners = new ArrayList<IOpenListener>();
        }
        this.openListeners.add(listener);
    }

    public void removeOpenListener(IOpenListener listener) {
        if (this.openListeners == null) {
            return;
        }
        this.openListeners.remove(listener);
    }

    private void asyncFireOpen(final OpenEvent event) {
        if (this.canvas.isDisposed()) {
            return;
        }
        final Display display = this.canvas.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                if (ImageButton.this.canvas.isDisposed() || display.isDisposed()) {
                    return;
                }
                ImageButton.this.fireOpen(event);
            }
        });
    }

    protected void fireOpen() {
        this.fireOpen(new OpenEvent((Viewer)this, this.getSelection()));
    }

    protected void fireOpen(final OpenEvent event) {
        if (this.openListeners == null || event == null) {
            return;
        }
        Object[] listeners = this.openListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            final IOpenListener listener = (IOpenListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.open(event);
                }
            });
            ++i;
        }
    }

    protected void dispose() {
        if (this.normalImage != null) {
            this.normalImage.dispose();
            this.normalImage = null;
        }
        if (this.pressedImage != null) {
            this.pressedImage.dispose();
            this.pressedImage = null;
        }
        if (this.disabledImage != null) {
            this.disabledImage.dispose();
            this.disabledImage = null;
        }
        if (this.hoveredImage != null) {
            this.hoveredImage.dispose();
            this.hoveredImage = null;
        }
    }

    public boolean isCheck() {
        return this.check;
    }

    public Object getInput() {
        return this.input;
    }

    public ISelection getSelection() {
        if (this.pressed) {
            if (this.getInput() != null) {
                return new StructuredSelection(this.getInput());
            }
            return new StructuredSelection((Object)this);
        }
        return StructuredSelection.EMPTY;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        boolean newState;
        if (selection == null) {
            return;
        }
        boolean bl = newState = !selection.isEmpty();
        if (newState == this.pressed) {
            return;
        }
        this.pressed = newState;
        this.refresh();
    }

    private final class EventHandler
    implements Listener {
        private EventHandler() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 9: {
                    ImageButton.this.handlePaint(event);
                    break;
                }
                case 12: {
                    ImageButton.this.handleDispose(event);
                    break;
                }
                case 3: {
                    ImageButton.this.handleMouseDown(event);
                    break;
                }
                case 4: {
                    ImageButton.this.handleMouseUp(event);
                    break;
                }
                case 6: {
                    ImageButton.this.handleMouseEnter(event);
                    break;
                }
                case 7: {
                    ImageButton.this.handleMouseExit(event);
                    break;
                }
                case 5: {
                    ImageButton.this.handleMouseMove(event);
                }
            }
        }
    }

    private final class ImageLayout
    extends Layout {
        private ImageLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Image img = ImageButton.this.getNormalImage();
            if (img == null) {
                return new Point(1, 1);
            }
            Rectangle bounds = img.getBounds();
            return new Point(bounds.width, bounds.height);
        }

        protected void layout(Composite composite, boolean flushCache) {
        }
    }
}

