/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.eclipse.ui.internal.misc.StringMatcher;

public class FileUtils {
    private static final long K = 1024L;
    private static final long M = 0x100000L;

    private FileUtils() {
    }

    public static String fileLengthToString(long length) {
        if (length < 1024L) {
            return String.valueOf(Long.toString(length)) + " B";
        }
        if (length >= 1024L && length < 0x100000L) {
            double tmp = (double)length / 1024.0;
            return String.format("%,.2f KB", tmp);
        }
        double tmp = (double)length / 1048576.0;
        return String.format("%,.2f MB", tmp);
    }

    public static String[] list(File path) {
        return FileUtils.list(path, null);
    }

    public static String[] list(File path, FilenameFilter filter) {
        return FileUtils.list(path, false, filter);
    }

    public static String[] list(File path, boolean extend, final FilenameFilter filter) {
        String pathName = path.getAbsolutePath();
        if (path.isFile() && path.exists()) {
            if (extend) {
                return FileUtils.list(new File(path.getParentFile(), String.valueOf(path.getName()) + "*"), false, filter);
            }
            if (filter == null || filter.accept(path.getParentFile(), path.getName())) {
                return new String[]{pathName};
            }
        } else if (path.isDirectory() && path.exists()) {
            File[] subFiles = path.listFiles(filter);
            if (subFiles != null) {
                ArrayList<String> list = new ArrayList<String>();
                File[] fileArray = subFiles;
                int n = subFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File subFile = fileArray[n2];
                    list.add(subFile.getAbsolutePath());
                    ++n2;
                }
                return list.toArray(new String[0]);
            }
        } else {
            int index = pathName.lastIndexOf(File.separatorChar);
            if (index >= 0) {
                File dir;
                String dirName = pathName.substring(0, index + 1);
                String filePattern = pathName.substring(index + 1, pathName.length());
                if (extend && !filePattern.endsWith("*")) {
                    filePattern = String.valueOf(filePattern) + "*";
                }
                if ((dir = new File(dirName)).isDirectory()) {
                    final StringMatcher matcher = new StringMatcher(filePattern, true, false);
                    return FileUtils.list(dir, false, new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return matcher.match(name) && (filter == null || filter.accept(dir, name));
                        }
                    });
                }
            }
        }
        return new String[0];
    }
}

