/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.richtext.Hyperlink;
import org.xmind.ui.richtext.ILineStyleModifier;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.IStyleRangeModifier;
import org.xmind.ui.richtext.ImagePlaceHolder;
import org.xmind.ui.richtext.LineStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTextUtils {
    static final String LineDelimiter = System.getProperty("line.separator");
    public static Font DEFAULT_FONT = JFaceResources.getDefaultFont();
    public static FontData DEFAULT_FONT_DATA = DEFAULT_FONT.getFontData()[0];
    public static Color DEFAULT_FOREGROUND = Display.getCurrent().getSystemColor(24);
    public static Color DEFAULT_BACKGROUND = Display.getCurrent().getSystemColor(25);
    public static final char INDENT_CHAR = '\t';
    public static final String EMPTY = "";
    public static final StyleRange DEFAULT_STYLE = new StyleRange();
    public static final LineStyle DEFAULT_LINE_STYLE = new LineStyle();

    private RichTextUtils() {
    }

    public static boolean isItalic(StyleRange style) {
        return RichTextUtils.hasFontStyle(style, 2);
    }

    public static boolean setItalic(StyleRange style, boolean italic) {
        return RichTextUtils.changeFontStyle(style, 2, italic);
    }

    public static boolean isBold(StyleRange style) {
        return RichTextUtils.hasFontStyle(style, 1);
    }

    public static boolean setBold(StyleRange style, boolean bold) {
        return RichTextUtils.changeFontStyle(style, 1, bold);
    }

    public static boolean hasFontStyle(StyleRange style, int singleStyle) {
        return (RichTextUtils.getFontStyle(style) & singleStyle) != 0;
    }

    public static boolean changeFontStyle(StyleRange style, int singleStyle, boolean value) {
        int changedFontStyle;
        int fontStyle = RichTextUtils.getFontStyle(style);
        if (fontStyle == (changedFontStyle = RichTextUtils.getChangedFontStyle(fontStyle, singleStyle, value))) {
            return false;
        }
        RichTextUtils.setFontStyle(style, changedFontStyle);
        return true;
    }

    public static int getChangedFontStyle(int fontStyle, int singleStyle, boolean value) {
        fontStyle = value ? (fontStyle |= singleStyle) : (fontStyle &= ~singleStyle);
        return fontStyle;
    }

    public static int getFontStyle(StyleRange style) {
        return style.font == null ? style.fontStyle : style.font.getFontData()[0].getStyle();
    }

    public static void setFontStyle(StyleRange style, int fontStyle) {
        style.fontStyle = fontStyle;
        if (style.font != null) {
            style.font = FontUtils.getStyled(style.font, fontStyle);
        }
    }

    public static int getFontStyle(boolean bold, boolean italic) {
        int fontStyle = 0;
        if (bold) {
            fontStyle |= 1;
        }
        if (italic) {
            fontStyle |= 2;
        }
        return fontStyle;
    }

    public static String getFontFace(StyleRange style) {
        return RichTextUtils.getFont(style).getFontData()[0].getName();
    }

    public static int getFontSize(StyleRange style) {
        return RichTextUtils.getFont(style).getFontData()[0].getHeight();
    }

    public static Font getFont(StyleRange style) {
        return style.font == null ? DEFAULT_FONT : style.font;
    }

    public static Color getForeground(StyleRange style) {
        return style.foreground == null ? DEFAULT_FOREGROUND : style.foreground;
    }

    public static Color getBackground(StyleRange style) {
        return style.background == null ? DEFAULT_BACKGROUND : style.background;
    }

    public static boolean setFont(StyleRange style, Font font) {
        if (font == style.font || font != null && RichTextUtils.equals(font, style.font)) {
            return false;
        }
        style.font = font;
        return true;
    }

    public static boolean setFontFace(StyleRange style, String name) {
        if (name == null) {
            name = DEFAULT_FONT_DATA.getName();
        }
        if (RichTextUtils.getFontFace(style).equals(name)) {
            return false;
        }
        style.font = FontUtils.getNewName(RichTextUtils.getFont(style), name);
        return true;
    }

    public static boolean setFontSize(StyleRange style, int size) {
        if (size <= 0) {
            size = DEFAULT_FONT_DATA.getHeight();
        }
        if (RichTextUtils.getFontSize(style) == size) {
            return false;
        }
        style.font = FontUtils.getNewHeight(RichTextUtils.getFont(style), size);
        return true;
    }

    public static boolean setForeground(StyleRange style, Color color) {
        if (color == style.foreground || color != null && color.equals((Object)style.foreground)) {
            return false;
        }
        style.foreground = color;
        return true;
    }

    public static boolean setBackground(StyleRange style, Color color) {
        if (color == style.background || color != null && color.equals((Object)style.background)) {
            return false;
        }
        style.background = color;
        return true;
    }

    public static List<Hyperlink> getHyperlinksInRange(Hyperlink[] hyperlinks, int start, int end) {
        ArrayList<Hyperlink> results = new ArrayList<Hyperlink>(hyperlinks.length);
        Hyperlink[] hyperlinkArray = hyperlinks;
        int n = hyperlinks.length;
        int n2 = 0;
        while (n2 < n) {
            Hyperlink hyperlink = hyperlinkArray[n2];
            if (hyperlink.start <= end && hyperlink.end() >= start) {
                results.add(hyperlink);
            }
            ++n2;
        }
        return results;
    }

    public static LineStyle updateLineStylePositions(int startLine, int oldLineCount, int newLineCount, List<LineStyle> lineStyles, IDocument document) {
        int lineIndex;
        int oldEndLine = startLine + oldLineCount;
        int deltaLines = newLineCount - oldLineCount;
        LineStyle firstInRange = null;
        int firstInRangeIndex = 0;
        int i = 0;
        while (i < lineStyles.size()) {
            LineStyle current = lineStyles.get(i);
            int currentLineIndex = current.lineIndex;
            if (currentLineIndex < startLine) {
                ++i;
                continue;
            }
            if (currentLineIndex >= oldEndLine) {
                current.lineIndex += deltaLines;
                ++i;
                continue;
            }
            if (currentLineIndex == startLine) {
                firstInRange = current;
                firstInRangeIndex = i++;
                continue;
            }
            lineStyles.remove(i);
        }
        int newEndLine = startLine + newLineCount;
        if (firstInRange != null) {
            int styleIndex = firstInRangeIndex + 1;
            lineIndex = firstInRange.lineIndex + 1;
            while (lineIndex < newEndLine) {
                LineStyle lineStyle = (LineStyle)firstInRange.clone();
                lineStyle.lineIndex = lineIndex;
                lineStyle.indent = RichTextUtils.calcLineIndentCount(document, lineIndex);
                lineStyles.add(styleIndex, lineStyle);
                ++styleIndex;
                ++lineIndex;
            }
        } else {
            int styleIndex = firstInRangeIndex;
            lineIndex = startLine;
            while (lineIndex < newEndLine) {
                int indent = RichTextUtils.calcLineIndentCount(document, lineIndex);
                if (indent > 0) {
                    LineStyle lineStyle = (LineStyle)DEFAULT_LINE_STYLE.clone();
                    lineStyle.indent = indent;
                    lineStyles.add(styleIndex, lineStyle);
                    ++styleIndex;
                }
                ++lineIndex;
            }
        }
        return firstInRange;
    }

    public static void updateImagePositions(int start, int oldLength, int newLength, List<ImagePlaceHolder> images) {
        int oldEnd = start + oldLength;
        int deltaOffset = newLength - oldLength;
        int imagePlaceHolderLength = "\ufffc".length();
        int i = 0;
        while (i < images.size()) {
            ImagePlaceHolder current = images.get(i);
            int currentStart = current.offset;
            int currentEnd = currentStart + imagePlaceHolderLength;
            if (currentEnd <= start) {
                ++i;
                continue;
            }
            if (currentStart >= oldEnd) {
                current.offset += deltaOffset;
                ++i;
                continue;
            }
            images.remove(i);
        }
    }

    public static void updateHyperlinksPositions(int start, int oldLength, int newLength, List<Hyperlink> hyperlinks) {
        int oldEnd = start + oldLength;
        int deltaOffset = newLength - oldLength;
        int i = 0;
        while (i < hyperlinks.size()) {
            Hyperlink currentHyper = hyperlinks.get(i);
            int currentStart = currentHyper.start;
            int currentEnd = currentHyper.end();
            if (oldEnd <= currentStart) {
                currentHyper.start += deltaOffset;
                ++i;
                continue;
            }
            if (start >= currentEnd) {
                ++i;
                continue;
            }
            if (oldEnd <= currentEnd && oldEnd > currentStart) {
                if (start >= currentStart) {
                    currentHyper.length += deltaOffset;
                    if (currentHyper.length == 0) {
                        hyperlinks.remove(i);
                        continue;
                    }
                } else {
                    currentHyper.length = currentHyper.end() - oldEnd;
                    currentHyper.start = oldEnd + deltaOffset;
                }
                ++i;
                continue;
            }
            if (start >= currentStart && start < currentEnd) {
                if (oldEnd <= currentEnd) {
                    currentHyper.length += deltaOffset;
                    if (currentHyper.length == 0) {
                        hyperlinks.remove(i);
                        continue;
                    }
                } else {
                    currentHyper.length = start - currentStart;
                }
                ++i;
                continue;
            }
            hyperlinks.remove(i);
        }
    }

    public static void replaceStyleRanges(int start, int oldLength, int newLength, List<StyleRange> styles, StyleRange replacement) {
        int oldEnd = start + oldLength;
        int deltaOffset = newLength - oldLength;
        StyleRange last = null;
        StyleRange lastStyleBeforeRange = null;
        int lastIndexBeforeRange = -1;
        int styleIndex = 0;
        while (styleIndex < styles.size()) {
            StyleRange current = styles.get(styleIndex);
            int currentStart = current.start;
            int currentLength = current.length;
            int currentEnd = currentStart + currentLength;
            if (currentEnd <= start) {
                last = current;
                lastStyleBeforeRange = current;
                lastIndexBeforeRange = styleIndex++;
                continue;
            }
            if (currentStart >= oldEnd) {
                current.start += deltaOffset;
                if (RichTextUtils.merge(current, last)) {
                    styles.remove(styleIndex);
                    continue;
                }
                ++styleIndex;
                continue;
            }
            if (currentStart < start) {
                StyleRange beforePart = (StyleRange)current.clone();
                beforePart.length = start - currentStart;
                styles.add(styleIndex, beforePart);
                current.start = currentStart = start;
                current.length = currentEnd - currentStart;
                last = beforePart;
                lastStyleBeforeRange = beforePart;
                lastIndexBeforeRange = styleIndex++;
            }
            if (currentEnd > oldEnd) {
                StyleRange afterPart = (StyleRange)current.clone();
                afterPart.start = oldEnd;
                afterPart.length = currentEnd - oldEnd;
                styles.add(styleIndex + 1, afterPart);
                currentEnd = oldEnd;
                current.length = currentEnd - currentStart;
            }
            styles.remove(styleIndex);
        }
        StyleRange newStyle = (StyleRange)replacement.clone();
        newStyle.start = start;
        newStyle.length = newLength;
        if (!RichTextUtils.merge(newStyle, lastStyleBeforeRange)) {
            styles.add(lastIndexBeforeRange + 1, newStyle);
        }
    }

    public static boolean modifyTextStyles(int start, int length, List<StyleRange> styles, IStyleRangeModifier modifier) {
        if (length == 0 || modifier == null) {
            return false;
        }
        int end = start + length;
        boolean changed = false;
        StyleRange last = null;
        int unhandledStart = start;
        int unhandledEnd = end;
        int unhandledIndex = 0;
        int styleIndex = 0;
        while (styleIndex < styles.size()) {
            StyleRange current = styles.get(styleIndex);
            int currentStart = current.start;
            int currentEnd = currentStart + current.length;
            if (currentEnd <= start) {
                last = current;
                unhandledIndex = ++styleIndex;
                continue;
            }
            if (currentStart >= end) {
                if (!RichTextUtils.merge(current, last)) break;
                styles.remove(styleIndex);
                changed = true;
                break;
            }
            if (currentStart < start) {
                unhandledStart = currentEnd;
                StyleRange beforePart = (StyleRange)current.clone();
                beforePart.length = start - currentStart;
                styles.add(styleIndex, beforePart);
                changed = true;
                last = beforePart;
                current.start = currentStart = start;
                current.length = currentEnd - currentStart;
                ++styleIndex;
            }
            if (currentEnd > end) {
                unhandledEnd = currentStart;
                StyleRange afterPart = (StyleRange)current.clone();
                afterPart.start = end;
                afterPart.length = currentEnd - end;
                styles.add(styleIndex + 1, afterPart);
                changed = true;
                currentEnd = end;
                current.length = currentEnd - currentStart;
            }
            if (currentStart >= unhandledStart) {
                if (currentStart > unhandledStart) {
                    StyleRange newStyle = (StyleRange)DEFAULT_STYLE.clone();
                    newStyle.start = unhandledStart;
                    newStyle.length = currentStart - unhandledStart;
                    modifier.modify(newStyle);
                    if (!RichTextUtils.merge(newStyle, last)) {
                        styles.add(styleIndex, newStyle);
                        last = newStyle;
                        ++styleIndex;
                    }
                    changed = true;
                }
                unhandledStart = currentEnd;
            }
            changed |= modifier.modify(current);
            if (RichTextUtils.merge(current, last)) {
                styles.remove(styleIndex);
                changed = true;
            } else {
                last = current;
            }
            unhandledIndex = ++styleIndex;
        }
        if (unhandledEnd > unhandledStart) {
            StyleRange newStyle = (StyleRange)DEFAULT_STYLE.clone();
            newStyle.start = unhandledStart;
            newStyle.length = unhandledEnd - unhandledStart;
            modifier.modify(newStyle);
            if (!RichTextUtils.merge(newStyle, last)) {
                styles.add(unhandledIndex, newStyle);
                changed = true;
            }
        }
        return changed;
    }

    public static boolean merge(StyleRange current, StyleRange last) {
        if (current == null) {
            return false;
        }
        if (current.length == 0) {
            return true;
        }
        if (last != null && last.start + last.length == current.start) {
            if (RichTextUtils.isSimilar(current, last)) {
                last.length += current.length;
                return true;
            }
            return false;
        }
        return RichTextUtils.isSimilar(current, DEFAULT_STYLE);
    }

    public static boolean modifyLineStyles(int startLine, int lineCount, List<LineStyle> lineStyles, ILineStyleModifier modifier) {
        int endLine = startLine + lineCount;
        int unhandledLine = startLine;
        int unhandledIndex = 0;
        boolean changed = false;
        int i = 0;
        while (i < lineStyles.size()) {
            LineStyle current = lineStyles.get(i);
            int currentLineIndex = current.lineIndex;
            if (currentLineIndex < startLine) {
                unhandledIndex = ++i;
                continue;
            }
            if (currentLineIndex >= endLine) break;
            if (currentLineIndex > unhandledLine) {
                LineStyle lineStyle = new LineStyle(unhandledLine);
                boolean modified = modifier.modify(lineStyle);
                changed |= modified;
                if (modified && !lineStyle.isUnstyled()) {
                    lineStyles.add(i, lineStyle);
                }
            } else {
                boolean modified = modifier.modify(current);
                changed |= modified;
                if (modified && current.isUnstyled()) {
                    lineStyles.remove(i);
                } else {
                    ++i;
                }
            }
            unhandledIndex = ++i;
            ++unhandledLine;
        }
        i = unhandledLine;
        while (i < endLine) {
            LineStyle lineStyle = new LineStyle(i);
            boolean modified = modifier.modify(lineStyle);
            changed |= modified;
            if (modified && !lineStyle.isUnstyled()) {
                lineStyles.add(unhandledIndex, lineStyle);
            }
            ++unhandledIndex;
            ++i;
        }
        return changed;
    }

    public static void replaceDocumentIndent(IDocument document, int line, int newIndent) throws BadLocationException {
        int lineLength;
        IRegion region = document.getLineInformation(line);
        int lineOffset = region.getOffset();
        String lineContent = document.get(lineOffset, lineLength = region.getLength());
        int oldIndent = RichTextUtils.calcIndentCount(lineContent);
        if (oldIndent != newIndent) {
            char[] chars = new char[newIndent];
            Arrays.fill(chars, '\t');
            String value = String.valueOf(chars);
            document.replace(lineOffset, oldIndent, value);
        }
    }

    public static void modifyDocumentIndent(IDocument document, int line, int deltaIndent) throws BadLocationException {
        int lineLength;
        String lineContent;
        int oldIndent;
        int deleteCount;
        if (deltaIndent == 0) {
            return;
        }
        IRegion region = document.getLineInformation(line);
        int lineOffset = region.getOffset();
        if (deltaIndent > 0) {
            char[] chars = new char[deltaIndent];
            Arrays.fill(chars, '\t');
            String value = String.valueOf(chars);
            document.replace(lineOffset, 0, value);
        } else if (deltaIndent < 0 && (deleteCount = Math.min(oldIndent = RichTextUtils.calcIndentCount(lineContent = document.get(lineOffset, lineLength = region.getLength())), Math.abs(deltaIndent))) > 0) {
            document.replace(lineOffset, deleteCount, EMPTY);
        }
    }

    public static int calcLineCount(String text) {
        int numDelimiter = 0;
        int length = text.length();
        int i = 0;
        while (i < length) {
            if (RichTextUtils.match(text, i, LineDelimiter)) {
                ++numDelimiter;
                i += LineDelimiter.length();
                continue;
            }
            ++i;
        }
        return numDelimiter + 1;
    }

    private static boolean match(String source, int start, String target) {
        int length = target.length();
        if (start + length > source.length()) {
            return false;
        }
        int i = 0;
        while (i < length) {
            char c2;
            char c1 = source.charAt(start + i);
            if (c1 != (c2 = target.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int calcLineIndentCount(IDocument document, int line) {
        try {
            IRegion region = document.getLineInformation(line);
            int lineOffset = region.getOffset();
            int lineLength = region.getLength();
            String lineContent = document.get(lineOffset, lineLength);
            return RichTextUtils.calcIndentCount(lineContent);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int calcIndentCount(String content) {
        int indent = 0;
        int i = 0;
        while (i < content.length()) {
            char c = content.charAt(i);
            if (c != '\t') {
                return indent;
            }
            ++indent;
            ++i;
        }
        return indent;
    }

    public static boolean isSimilar(StyleRange sr1, StyleRange sr2) {
        if (sr1 == sr2) {
            return true;
        }
        if (sr1 == null || sr2 == null) {
            return false;
        }
        if (!RichTextUtils.equals((TextStyle)sr1, (TextStyle)sr2)) {
            return false;
        }
        return sr1.fontStyle == sr2.fontStyle;
    }

    public static boolean equals(TextStyle style1, TextStyle style2) {
        if (style1 == style2) {
            return true;
        }
        if (style1 == null || style2 == null) {
            return false;
        }
        if (style1.foreground != null ? !style1.foreground.equals((Object)style2.foreground) : style2.foreground != null) {
            return false;
        }
        if (style1.background != null ? !style1.background.equals((Object)style2.background) : style2.background != null) {
            return false;
        }
        if (style1.font != null ? !RichTextUtils.equals(style1.font, style2.font) : style2.font != null) {
            return false;
        }
        if (style1.metrics != null || style2.metrics != null) {
            return false;
        }
        if (style1.underline != style2.underline) {
            return false;
        }
        if (style1.strikeout != style2.strikeout) {
            return false;
        }
        return style1.rise == style2.rise;
    }

    public static boolean equals(Font f1, Font f2) {
        if (f1 == f2) {
            return true;
        }
        if (f1 == null && f2 != null) {
            return false;
        }
        if (f2 == null && f1 != null) {
            return false;
        }
        if (!"carbon".equals(SWT.getPlatform())) {
            return f1.equals((Object)f2);
        }
        if (f1.isDisposed() || f2.isDisposed()) {
            return false;
        }
        FontData fd1 = f1.getFontData()[0];
        FontData fd2 = f2.getFontData()[0];
        return fd1.equals((Object)fd2);
    }

    public static void replaceHyperlinkHref(IRichDocument doc, Hyperlink hyperlink, String newHref) {
        Hyperlink newHyperlink = (Hyperlink)hyperlink.clone();
        newHyperlink.href = newHref;
        Hyperlink[] oldHyperlinks = doc.getHyperlinks();
        ArrayList<Hyperlink> newHyperlinks = new ArrayList<Hyperlink>(oldHyperlinks.length);
        Hyperlink[] hyperlinkArray = oldHyperlinks;
        int n = oldHyperlinks.length;
        int n2 = 0;
        while (n2 < n) {
            Hyperlink oldHyperlink = hyperlinkArray[n2];
            if (oldHyperlink.start == hyperlink.start && oldHyperlink.length == hyperlink.length) {
                newHyperlinks.add(newHyperlink);
            } else {
                newHyperlinks.add(oldHyperlink);
            }
            ++n2;
        }
        doc.setHyperlinks(newHyperlinks.toArray(new Hyperlink[newHyperlinks.size()]));
    }
}

