/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class AlignmentGroup
extends ContributionItem {
    private List<IAction> actions = new ArrayList<IAction>();
    private IAction currentAction = null;
    private IPropertyChangeListener actionListener = null;
    private Listener toolItemListener;
    private ToolItem widget = null;
    private IPropertyChangeListener currentActionListener = null;
    private MenuManager dropDownMenuManager = null;
    private LocalResourceManager imageManager;

    public void add(IAction action) {
        this.actions.add(action);
        action.addPropertyChangeListener(this.getActionListener());
        if (this.currentAction == null) {
            this.setCurrentAction(action);
        }
    }

    public void remove(IAction action) {
        action.removePropertyChangeListener(this.getActionListener());
        this.actions.remove(action);
        if (this.currentAction == action) {
            this.setCurrentAction(this.actions.isEmpty() ? null : this.actions.get(0));
        }
    }

    public IAction getCurrentAction() {
        return this.currentAction;
    }

    public void setCurrentAction(IAction action) {
        if (this.currentAction != null && this.currentActionListener != null) {
            this.currentAction.removePropertyChangeListener(this.currentActionListener);
        }
        this.currentAction = action;
        if (action != null) {
            action.setChecked(true);
        }
        for (IAction a : this.actions) {
            if (a == action) continue;
            a.setChecked(false);
        }
        if (action != null && this.widget != null && !this.widget.isDisposed()) {
            action.addPropertyChangeListener(this.getCurrentActionListener());
        }
        this.update(null);
    }

    private IPropertyChangeListener getActionListener() {
        if (this.actionListener == null) {
            this.actionListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    AlignmentGroup.this.actionPropertyChange(event);
                }
            };
        }
        return this.actionListener;
    }

    protected void actionPropertyChange(PropertyChangeEvent event) {
        IAction triggerAction = (IAction)event.getSource();
        String property = event.getProperty();
        if ("checked".equals(property) && Boolean.TRUE.equals(event.getNewValue())) {
            this.setCurrentAction(triggerAction);
        }
    }

    public void fill(Menu menu, int index) {
        for (IAction action : this.actions) {
            new ActionContributionItem(action).fill(menu, index++);
        }
    }

    public void fill(ToolBar parent, int index) {
        if (this.widget == null && parent != null) {
            int flags = 4;
            ToolItem ti = null;
            ti = index >= 0 ? new ToolItem(parent, flags, index) : new ToolItem(parent, flags);
            ti.setData((Object)this);
            ti.addListener(13, this.getToolItemListener());
            ti.addListener(12, this.getToolItemListener());
            this.widget = ti;
            this.update(null);
            if (this.currentAction != null) {
                this.currentAction.addPropertyChangeListener(this.getCurrentActionListener());
            }
        }
    }

    private IPropertyChangeListener getCurrentActionListener() {
        if (this.currentActionListener == null) {
            this.currentActionListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    AlignmentGroup.this.currentActionPropertyChange(event);
                }
            };
        }
        return this.currentActionListener;
    }

    private void currentActionPropertyChange(final PropertyChangeEvent e) {
        if (this.isVisible() && this.widget != null) {
            Display display = this.widget.getDisplay();
            if (display.getThread() == Thread.currentThread()) {
                this.update(e.getProperty());
            } else {
                display.asyncExec(new Runnable(){

                    public void run() {
                        AlignmentGroup.this.update(e.getProperty());
                    }
                });
            }
        }
    }

    public void update() {
        this.update(null);
    }

    public void update(String propertyName) {
        boolean showText;
        if (this.widget == null || this.currentAction == null) {
            return;
        }
        boolean textChanged = propertyName == null || propertyName.equals("text");
        boolean imageChanged = propertyName == null || propertyName.equals("image");
        boolean tooltipTextChanged = propertyName == null || propertyName.equals("toolTipText");
        boolean enableStateChanged = propertyName == null || propertyName.equals("enabled") || propertyName.equals("enabled");
        boolean checkChanged = !(this.currentAction.getStyle() != 2 && this.currentAction.getStyle() != 8 || propertyName != null && !propertyName.equals("checked"));
        ToolItem ti = this.widget;
        String text = this.currentAction.getText();
        boolean bl = showText = text != null && !this.hasImages(this.currentAction);
        if (showText && text != null) {
            text = Action.removeAcceleratorText((String)text);
            text = Action.removeMnemonics((String)text);
        }
        if (textChanged) {
            boolean rightStyle;
            String textToSet = showText ? text : "";
            boolean bl2 = rightStyle = (ti.getParent().getStyle() & 0x20000) != 0;
            if (rightStyle || !ti.getText().equals(textToSet)) {
                ti.setText(textToSet);
            }
        }
        if (imageChanged) {
            this.updateImages(!showText);
        }
        if (tooltipTextChanged || textChanged) {
            String acceleratorText;
            String toolTip = this.currentAction.getToolTipText();
            if (toolTip == null || toolTip.length() == 0) {
                toolTip = text;
            }
            ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
            String commandId = this.currentAction.getActionDefinitionId();
            if (callback != null && commandId != null && toolTip != null && (acceleratorText = callback.getAcceleratorText(commandId)) != null && acceleratorText.length() != 0) {
                toolTip = JFaceResources.format((String)"Toolbar_Tooltip_Accelerator", (Object[])new Object[]{toolTip, acceleratorText});
            }
            if (!showText || toolTip != null && !toolTip.equals(text)) {
                ti.setToolTipText(toolTip);
            } else {
                ti.setToolTipText(null);
            }
        }
        if (enableStateChanged) {
            boolean shouldBeEnabled;
            boolean bl3 = shouldBeEnabled = this.currentAction.isEnabled() && this.isEnabledAllowed();
            if (ti.getEnabled() != shouldBeEnabled) {
                ti.setEnabled(shouldBeEnabled);
            }
        }
        if (checkChanged) {
            boolean bv = this.currentAction.isChecked();
            if (ti.getSelection() != bv) {
                ti.setSelection(bv);
            }
        }
    }

    private boolean hasImages(IAction actionToCheck) {
        return actionToCheck.getImageDescriptor() != null || actionToCheck.getHoverImageDescriptor() != null || actionToCheck.getDisabledImageDescriptor() != null;
    }

    private boolean updateImages(boolean forceImage) {
        ResourceManager parentResourceManager = JFaceResources.getResources();
        ImageDescriptor image = this.currentAction.getHoverImageDescriptor();
        if (image == null) {
            image = this.currentAction.getImageDescriptor();
        }
        ImageDescriptor disabledImage = this.currentAction.getDisabledImageDescriptor();
        if (image == null && forceImage) {
            image = ImageDescriptor.getMissingImageDescriptor();
        }
        LocalResourceManager localManager = new LocalResourceManager(parentResourceManager);
        this.widget.setDisabledImage(disabledImage == null ? null : localManager.createImageWithDefault(disabledImage));
        this.widget.setImage(image == null ? null : localManager.createImageWithDefault(image));
        this.disposeOldImages();
        this.imageManager = localManager;
        return image != null;
    }

    protected boolean isEnabledAllowed() {
        if (this.getParent() == null) {
            return true;
        }
        Boolean value = this.getParent().getOverrides().getEnabled((IContributionItem)this);
        return value == null ? true : value;
    }

    private Listener getToolItemListener() {
        if (this.toolItemListener == null) {
            this.toolItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            AlignmentGroup.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget ew = event.widget;
                            if (ew == null) break;
                            AlignmentGroup.this.handleWidgetSelection(event, ((ToolItem)ew).getSelection());
                        }
                    }
                }
            };
        }
        return this.toolItemListener;
    }

    private void handleWidgetDispose(Event e) {
        if (e.widget == this.widget) {
            if (this.dropDownMenuManager != null) {
                this.dropDownMenuManager.dispose();
                this.dropDownMenuManager = null;
            }
            if (this.currentAction != null && this.currentActionListener != null) {
                this.currentAction.removePropertyChangeListener(this.currentActionListener);
            }
            this.widget = null;
            this.disposeOldImages();
        }
    }

    private MenuManager getDropDownMenuManager() {
        if (this.dropDownMenuManager == null) {
            this.dropDownMenuManager = new MenuManager();
            this.dropDownMenuManager.setRemoveAllWhenShown(true);
            this.dropDownMenuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    for (IAction action : AlignmentGroup.this.actions) {
                        manager.add(action);
                    }
                }
            });
        }
        return this.dropDownMenuManager;
    }

    private void handleWidgetSelection(Event e, boolean selection) {
        MenuManager menuMan;
        Menu menu;
        if (e.widget == this.widget && (menu = (menuMan = this.getDropDownMenuManager()).createContextMenu((Control)this.widget.getParent())) != null) {
            Rectangle b = this.widget.getBounds();
            Point p = this.widget.getParent().toDisplay(b.x, b.y + b.height);
            menu.setLocation(p.x, p.y);
            menu.setVisible(true);
        }
    }

    private void disposeOldImages() {
        if (this.imageManager != null) {
            this.imageManager.dispose();
            this.imageManager = null;
        }
    }
}

