/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.io;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xmind.ui.io.StreamInterruptedException;

public class MonitoredInputStream
extends InputStream {
    private InputStream realStream;
    private IProgressMonitor monitor;

    public MonitoredInputStream(InputStream realStream, IProgressMonitor monitor) {
        this.realStream = realStream;
        this.monitor = monitor;
    }

    private void closeRealStream() {
        try {
            this.realStream.close();
        }
        catch (IOException iOException) {}
    }

    public int read() throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new StreamInterruptedException();
        }
        return this.realStream.read();
    }

    public int available() throws IOException {
        return this.realStream.available();
    }

    public void close() throws IOException {
        this.realStream.close();
    }

    public void mark(int readlimit) {
        this.realStream.mark(readlimit);
    }

    public boolean markSupported() {
        return this.realStream.markSupported();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new StreamInterruptedException();
        }
        return this.realStream.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new StreamInterruptedException();
        }
        return this.realStream.read(b);
    }

    public void reset() throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new StreamInterruptedException();
        }
        this.realStream.reset();
    }

    public long skip(long n) throws IOException {
        if (this.monitor.isCanceled()) {
            this.closeRealStream();
            throw new StreamInterruptedException();
        }
        return this.realStream.skip(n);
    }
}

