/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.databinding.provisional.swt.AbstractSWTObservableValue;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Widget;

public class ScaleObservableValue
extends AbstractSWTObservableValue {
    private final Scale scale;
    private final String attribute;
    private boolean updating = false;
    private int currentSelection;
    private SelectionListener listener;

    public ScaleObservableValue(Scale scale, String attribute) {
        super((Widget)scale);
        this.scale = scale;
        this.attribute = attribute;
        this.init();
    }

    public ScaleObservableValue(Realm realm, Scale scale, String attribute) {
        super(realm, (Widget)scale);
        this.scale = scale;
        this.attribute = attribute;
        this.init();
    }

    private void init() {
        if (this.attribute.equals("selection")) {
            this.currentSelection = this.scale.getSelection();
            this.listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!ScaleObservableValue.this.updating) {
                        int newSelection = ScaleObservableValue.this.scale.getSelection();
                        ScaleObservableValue.this.notifyIfChanged(ScaleObservableValue.this.currentSelection, newSelection);
                        ScaleObservableValue.this.currentSelection = newSelection;
                    }
                }
            };
            this.scale.addSelectionListener(this.listener);
        } else if (!this.attribute.equals("min") && !this.attribute.equals("max")) {
            throw new IllegalArgumentException("Attribute name not valid: " + this.attribute);
        }
    }

    public void doSetValue(Object value) {
        try {
            int oldValue;
            this.updating = true;
            int newValue = (Integer)value;
            if (this.attribute.equals("selection")) {
                oldValue = this.scale.getSelection();
                this.scale.setSelection(newValue);
                this.currentSelection = newValue;
            } else if (this.attribute.equals("min")) {
                oldValue = this.scale.getMinimum();
                this.scale.setMinimum(newValue);
            } else if (this.attribute.equals("max")) {
                oldValue = this.scale.getMaximum();
                this.scale.setMaximum(newValue);
            } else {
                Assert.isTrue((boolean)false, (String)("invalid attribute name:" + this.attribute));
                return;
            }
            this.notifyIfChanged(oldValue, newValue);
        }
        finally {
            this.updating = false;
        }
    }

    public Object doGetValue() {
        int value = 0;
        if (this.attribute.equals("selection")) {
            value = this.scale.getSelection();
        } else if (this.attribute.equals("min")) {
            value = this.scale.getMinimum();
        } else if (this.attribute.equals("max")) {
            value = this.scale.getMaximum();
        }
        return new Integer(value);
    }

    public Object getValueType() {
        return Integer.TYPE;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.listener != null && !this.scale.isDisposed()) {
            this.scale.removeSelectionListener(this.listener);
        }
        this.listener = null;
    }

    private void notifyIfChanged(int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.fireValueChange(Diffs.createValueDiff((Object)new Integer(oldValue), (Object)new Integer(newValue)));
        }
    }
}

