/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.imports.freemind;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.core.Core;
import org.xmind.core.IBoundary;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.INotesContent;
import org.xmind.core.IParagraph;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ISheet;
import org.xmind.core.ISpan;
import org.xmind.core.ITextSpan;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.io.ResourceMappingManager;
import org.xmind.core.io.freemind.FreeMindConstants;
import org.xmind.core.io.freemind.FreeMindResourceMappingManager;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.DOMUtils;
import org.xmind.ui.internal.imports.ImportMessages;
import org.xmind.ui.internal.imports.ImporterUtils;
import org.xmind.ui.io.MonitoredInputStream;
import org.xmind.ui.wizards.MindMapImporter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeMindImporter
extends MindMapImporter
implements FreeMindConstants,
ErrorHandler {
    private static DocumentBuilder documentBuilder = null;
    private static ResourceMappingManager mappings = null;
    private Map<String, String> idMap = new HashMap<String, String>();
    private IStyleSheet tempStyleSheet = null;
    private List<ArrowLink> links = null;

    public FreeMindImporter(String sourcePath, IWorkbook targetWorkbook) {
        super(sourcePath, targetWorkbook);
    }

    public FreeMindImporter(String sourcePath) {
        super(sourcePath);
    }

    public void build() throws InvocationTargetException, InterruptedException {
        try {
            Document doc;
            DocumentBuilder builder = this.getDocumentBuilder();
            builder.setErrorHandler(this);
            FileInputStream in = new FileInputStream(this.getSourcePath());
            try {
                in = new MonitoredInputStream((InputStream)in, this.getMonitor());
                doc = builder.parse(in);
            }
            catch (Throwable throwable) {
                builder.setErrorHandler(null);
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            builder.setErrorHandler(null);
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
            this.loadSheet(doc.getDocumentElement());
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
    }

    private void checkInterrupted() throws InterruptedException {
        if (this.getMonitor().isCanceled()) {
            throw new InterruptedException();
        }
    }

    private void loadSheet(Element docEle) throws InterruptedException {
        this.checkInterrupted();
        ISheet sheet = this.getTargetWorkbook().createSheet();
        Element nodeEle = FreeMindImporter.child(docEle, "node");
        if (nodeEle != null) {
            this.loadTopic(sheet.getRootTopic(), nodeEle);
        } else {
            sheet.getRootTopic().setTitleText(ImportMessages.Importer_CentralTopic);
        }
        this.arrangeRelationships();
        String bgColor = FreeMindImporter.att(docEle, "backgound_color");
        if (bgColor != null) {
            IStyle style = this.getTempStyleSheet().createStyle("map");
            style.setProperty("svg:fill", bgColor);
            style = this.getTargetWorkbook().getStyleSheet().importStyle(style);
            if (style != null) {
                sheet.setStyleId(style.getId());
            }
        }
        this.addTargetSheet(sheet);
    }

    private void arrangeRelationships() {
    }

    private void loadTopic(ITopic topic, Element topicEle) throws InterruptedException {
        IPlainNotesContent notesContent;
        String type;
        String toId;
        this.checkInterrupted();
        String id = FreeMindImporter.att(topicEle, "ID");
        if (id != null) {
            this.idMap.put(id, topic.getId());
        }
        this.checkInterrupted();
        String text = FreeMindImporter.att(topicEle, "TEXT");
        if (text == null) {
            text = ImporterUtils.getDefaultTopicTitle(topic);
        }
        topic.setTitleText(text);
        this.checkInterrupted();
        String folded = FreeMindImporter.att(topicEle, "FOLDED");
        if (folded != null && "true".equals(folded)) {
            topic.setFolded(true);
        }
        this.checkInterrupted();
        String link = FreeMindImporter.att(topicEle, "LINK");
        if (link != null) {
            topic.setHyperlink(link);
        }
        this.checkInterrupted();
        Element ele = null;
        if (!topic.isRoot() && (ele = FreeMindImporter.child(topicEle, "cloud")) != null) {
            IBoundary boundary = this.getTargetWorkbook().createBoundary();
            int index = topic.getIndex();
            boundary.setStartIndex(index);
            boundary.setEndIndex(index);
            topic.getParent().addBoundary(boundary);
        }
        this.checkInterrupted();
        ele = FreeMindImporter.child(topicEle, "arrowlink");
        if (ele != null && (toId = FreeMindImporter.att(ele, "DESTINATION")) != null) {
            ArrowLink arrowLink = new ArrowLink(id, toId);
            if (this.links == null) {
                this.links = new ArrayList<ArrowLink>();
            }
            this.links.add(arrowLink);
        }
        Iterator<Element> it = FreeMindImporter.children(topicEle, "icon");
        while (it.hasNext()) {
            String markerId;
            this.checkInterrupted();
            Element iconEle = it.next();
            String builtIn = FreeMindImporter.att(iconEle, "BUILTIN");
            if (builtIn == null || (markerId = FreeMindImporter.getTransferred("marker", builtIn, null)) == null) continue;
            topic.addMarker(markerId);
        }
        it = FreeMindImporter.children(topicEle, "hook");
        while (it.hasNext()) {
            Element textEle;
            this.checkInterrupted();
            Element hookEle = it.next();
            type = FreeMindImporter.att(hookEle, "NAME");
            if (type == null || !"accessories/plugins/NodeNote.properties".equals(type) || (textEle = FreeMindImporter.child(hookEle, "text")) == null) continue;
            notesContent = (IPlainNotesContent)this.getTargetWorkbook().createNotesContent("plain");
            notesContent.setTextContent(textEle.getTextContent());
            topic.getNotes().setContent("plain", (INotesContent)notesContent);
            break;
        }
        it = FreeMindImporter.children(topicEle, "richcontent");
        while (it.hasNext()) {
            Element htmlEle;
            this.checkInterrupted();
            Element richEle = it.next();
            type = FreeMindImporter.att(richEle, "TYPE");
            if (type == null || !"NOTE".equals(type) || (htmlEle = FreeMindImporter.child(richEle, "html")) == null) continue;
            notesContent = (IHtmlNotesContent)this.getTargetWorkbook().createNotesContent("html");
            new NotesImporter((IHtmlNotesContent)notesContent).importFrom(htmlEle);
            topic.getNotes().setContent("html", (INotesContent)notesContent);
            break;
        }
        it = FreeMindImporter.children(topicEle, "node");
        while (it.hasNext()) {
            this.checkInterrupted();
            Element subTopicEle = it.next();
            ITopic subTopic = this.getTargetWorkbook().createTopic();
            topic.add(subTopic);
            this.loadTopic(subTopic, subTopicEle);
        }
    }

    private IStyleSheet getTempStyleSheet() {
        if (this.tempStyleSheet == null) {
            this.tempStyleSheet = Core.getStyleSheetBuilder().createStyleSheet();
        }
        return this.tempStyleSheet;
    }

    private static Element child(Element parentEle, String childTag) {
        return FreeMindImporter.children(parentEle, childTag).next();
    }

    private static Iterator<Element> children(Element parentEle, String childTag) {
        return new Iterator<Element>(childTag, parentEle){
            String tag;
            Iterator<Element> it;
            Element next;
            {
                this.tag = DOMUtils.getLocalName((String)string);
                this.it = DOMUtils.childElementIter((Node)element);
                this.next = this.findNext();
            }

            @Override
            public void remove() {
            }

            private Element findNext() {
                while (this.it.hasNext()) {
                    Element ele = this.it.next();
                    if (!DOMUtils.getLocalName((String)ele.getTagName()).equalsIgnoreCase(this.tag)) continue;
                    return ele;
                }
                return null;
            }

            @Override
            public Element next() {
                Element result = this.next;
                this.next = this.findNext();
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }
        };
    }

    private static String att(Element ele, String attName) {
        if (ele.hasAttribute(attName)) {
            return ele.getAttribute(attName);
        }
        attName = DOMUtils.getLocalName((String)attName);
        NamedNodeMap atts = ele.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            Node att = atts.item(i);
            if (attName.equalsIgnoreCase(DOMUtils.getLocalName((String)att.getNodeName()))) {
                return att.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    private static String getTransferred(String type, String sourceId, String defaultId) {
        String destination;
        ResourceMappingManager mappings;
        if (sourceId != null && (mappings = FreeMindImporter.getMappings()) != null && (destination = mappings.getDestination(type, sourceId)) != null) {
            return destination;
        }
        return defaultId;
    }

    private static ResourceMappingManager getMappings() {
        if (mappings == null) {
            mappings = FreeMindImporter.createMappings();
        }
        return mappings;
    }

    private static ResourceMappingManager createMappings() {
        return FreeMindResourceMappingManager.getInstance();
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (documentBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://apache.org/xml/features/continue-after-fatal-error", true);
            documentBuilder = factory.newDocumentBuilder();
        }
        return documentBuilder;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }

    private class ArrowLink {
        String fromId;
        String toId;

        public ArrowLink(String fromId, String toId) {
            this.fromId = fromId;
            this.toId = toId;
        }
    }

    private class NotesImporter {
        IHtmlNotesContent content;
        IParagraph currentParagraph;

        public NotesImporter(IHtmlNotesContent content) {
            this.content = content;
        }

        public void importFrom(Element htmlEle) throws InterruptedException {
            FreeMindImporter.this.checkInterrupted();
            String tagName = DOMUtils.getLocalName((String)htmlEle.getTagName());
            if ("p".equalsIgnoreCase(tagName)) {
                this.addParagraph();
            } else if ("li".equalsIgnoreCase(tagName)) {
                this.addParagraph();
            } else if ("br".equalsIgnoreCase(tagName)) {
                this.addParagraph();
            }
            NodeList nl = htmlEle.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node e = nl.item(i);
                if (e.getNodeType() == 3) {
                    this.addText(e.getTextContent());
                } else if (e.getNodeType() == 1) {
                    this.importFrom((Element)e);
                }
                ++i;
            }
        }

        private void addText(String textContent) {
            if (this.currentParagraph == null) {
                this.addParagraph();
            }
            ITextSpan span = this.content.createTextSpan(textContent);
            this.currentParagraph.addSpan((ISpan)span);
        }

        private void addParagraph() {
            this.currentParagraph = this.content.createParagraph();
            this.content.addParagraph(this.currentParagraph);
        }
    }
}

