/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.osgi.framework.Bundle;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.CathyWorkbenchAdvisor;
import org.xmind.cathy.internal.IApplicationValidator;
import org.xmind.cathy.internal.Log;

public class CathyApplication
implements IApplication {
    public static final String ARG_ACTIVATE = "--activate";

    public Object start(IApplicationContext context) throws Exception {
        String[] args = Platform.getApplicationArgs();
        if (args != null && args.length > 0) {
            this.logArgs(args);
        }
        if (this.shouldExitEarly()) {
            return EXIT_OK;
        }
        Display display = PlatformUI.createDisplay();
        try {
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new CathyWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = EXIT_RESTART;
                return n;
            }
            Integer n = EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    private void logArgs(String[] args) {
        Log opening = Log.get(".opening");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            File file = new File(arg);
            if (file.isFile()) {
                try {
                    arg = file.getCanonicalPath();
                }
                catch (Exception exception) {
                    arg = file.getAbsolutePath();
                }
                opening.append(arg);
            } else if ("-p".equals(arg)) {
                opening.append("-p");
            }
            ++n2;
        }
    }

    private boolean shouldExitEarly() {
        Bundle bundle = CathyPlugin.getDefault().getBundle();
        try {
            Class clazz = bundle.loadClass("org.xmind.cathy.internal.ApplicationValidator");
            if (IApplicationValidator.class.isAssignableFrom(clazz)) {
                try {
                    return ((IApplicationValidator)clazz.newInstance()).shouldApplicationExitEarly();
                }
                catch (Exception exception) {}
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return false;
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }
}

