/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.tool;

import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.tool.AbstractTool;
import org.xmind.gef.tool.GraphicalTool;
import org.xmind.gef.tool.IDraggingTool;
import org.xmind.gef.tool.ITool;

public abstract class CreateTool
extends GraphicalTool {
    protected boolean handleMouseDown(MouseEvent me) {
        if (me.leftOrRight) {
            if (this.canFinishOnLeftMouseDown(me)) {
                this.finish();
                return true;
            }
        } else if (this.canCancelOnRightMouseDown(me)) {
            this.cancel();
            ((AbstractTool)this.getDomain().getActiveTool()).getStatus().setStatus(512, true);
            return true;
        }
        return super.handleMouseDown(me);
    }

    protected abstract boolean canFinishOnLeftMouseDown(MouseEvent var1);

    protected abstract boolean canCancelOnRightMouseDown(MouseEvent var1);

    protected boolean handleKeyDown(KeyEvent ke) {
        if (this.shouldCancel(ke)) {
            this.cancel();
            return true;
        }
        return super.handleKeyDown(ke);
    }

    protected abstract boolean shouldCancel(KeyEvent var1);

    protected void finish() {
        this.changeToNextTool();
    }

    protected void cancel() {
        this.changeToNextTool();
    }

    protected void changeToNextTool() {
        this.changeActiveTool(this.getNextTool());
    }

    protected String getNextTool() {
        return "default tool";
    }

    protected abstract boolean canFinish(String var1);

    protected void handleSingleRequest(Request request) {
        if (request.getTargetViewer() == null || request.getTargetViewer() != this.getTargetViewer()) {
            super.handleSingleRequest(request);
            return;
        }
        String requestType = request.getType();
        if ("finish".equals(requestType) && this.getStatus().isStatus(1)) {
            if (this.canFinish(requestType)) {
                this.finish();
            }
        } else if ("cancel".equals(requestType) && this.getStatus().isStatus(1)) {
            this.cancel();
        } else if (this.isViewRequest(requestType)) {
            ITool defaultTool = this.getDomain().getTool("default tool");
            if (defaultTool != null) {
                defaultTool.handleRequest(request);
            }
        } else {
            ITool tool;
            if (this.getStatus().isStatus(1)) {
                this.cancel();
            }
            if ((tool = this.getDomain().getActiveTool()) != this) {
                tool.handleRequest(request);
            }
        }
    }

    protected boolean isViewRequest(String reqType) {
        return this.isViewRole(this.getDomain().getPartRoles().getRole(reqType));
    }

    protected boolean isViewRole(String role) {
        return "selectable role".equals(role) || "scalable role".equals(role);
    }

    protected void internalHandleRequest(Request request) {
        super.handleSingleRequest(request);
    }

    protected void internalHandleRequest(String requestType, IViewer viewer) {
        super.handleRequest(requestType, viewer);
    }

    protected ITool copyStatus(ITool next) {
        if ((next = super.copyStatus(next)) instanceof IDraggingTool) {
            ((IDraggingTool)((Object)next)).setStartingPosition(this.getCursorPosition());
        }
        if (next instanceof AbstractTool) {
            ((AbstractTool)next).getStatus().setStatus(2048, true);
        }
        return next;
    }
}

