/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.service;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.draw2d.PointFigure;
import org.xmind.gef.service.AbstractFeedback;
import org.xmind.gef.service.IPointProvider;

public class PointFeedback
extends AbstractFeedback {
    public static final int DOT = 2;
    public static final int DIAMOND = 3;
    public static final int SQUARE = 1;
    private int pointShape;
    private int height;
    private Color borderColor;
    private Color fillColor;
    private int alpha;
    private PointFigure figure;
    private Point position;
    private IPointProvider positionProvider;

    public PointFeedback(int pointShape) {
        this.pointShape = pointShape;
    }

    public void addToLayer(IFigure layer) {
        if (this.figure == null) {
            this.figure = this.createFigure();
        }
        layer.add((IFigure)this.figure);
    }

    private PointFigure createFigure() {
        PointFigure figure = new PointFigure(this.pointShape);
        figure.setSize(this.height, this.height);
        figure.setForegroundColor(this.borderColor);
        figure.setBackgroundColor(this.fillColor);
        figure.setMainAlpha(this.alpha);
        figure.setSubAlpha(this.alpha);
        return figure;
    }

    public boolean containsPoint(Point point) {
        if (this.figure != null && this.position != null) {
            if (this.getZoomManager() != null) {
                point = this.getZoomManager().getScaled(point);
            }
            return this.figure.containsPoint(point) && this.figure.isShowing();
        }
        return false;
    }

    public void removeFromLayer(IFigure layer) {
        if (this.figure != null) {
            layer.remove((IFigure)this.figure);
        }
    }

    public void update() {
        Point p;
        if (this.figure == null) {
            return;
        }
        if (this.positionProvider != null && (p = this.positionProvider.getPoint()) != null) {
            this.setPosition(p);
        }
        if (this.position != null) {
            this.figure.setReference(this.getScaledPosition(this.position));
        }
        this.figure.setSize(this.height, this.height);
        this.figure.setForegroundColor(this.borderColor);
        this.figure.setBackgroundColor(this.fillColor);
        this.figure.setMainAlpha(this.alpha);
        this.figure.setSubAlpha(this.alpha);
    }

    private Point getScaledPosition(Point p) {
        if (this.getZoomManager() != null) {
            p = this.getZoomManager().getScaled(p);
        }
        return p;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public IPointProvider getPositionProvider() {
        return this.positionProvider;
    }

    public void setPositionProvider(IPointProvider positionProvider) {
        this.positionProvider = positionProvider;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

