/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.IViewer;
import org.xmind.gef.service.AbstractViewerService;
import org.xmind.gef.service.IImageRegistryService;

public class ImageRegistryService
extends AbstractViewerService
implements IImageRegistryService {
    private Map<ImageDescriptor, ImageCache> caches = new HashMap<ImageDescriptor, ImageCache>(30);
    private Device device;

    public ImageRegistryService(IViewer viewer) {
        super(viewer);
    }

    protected void activate() {
    }

    protected void deactivate() {
    }

    public void decreaseRef(ImageDescriptor imageDescriptor, Object reference) {
        ImageCache cache = this.caches.get(imageDescriptor);
        if (cache != null) {
            cache.decreaseRef(reference);
            if (!cache.hasReferences()) {
                this.caches.remove(imageDescriptor);
            }
        }
    }

    public Image getImage(ImageDescriptor imageDescriptor, boolean returnMissingImageOnError, Object reference) {
        ImageCache cache;
        if (imageDescriptor == null) {
            if (!returnMissingImageOnError) {
                return null;
            }
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((cache = this.caches.get(imageDescriptor)) == null) {
            cache = new ImageCache(imageDescriptor);
            this.caches.put(imageDescriptor, cache);
        }
        return cache.getImage(returnMissingImageOnError, reference);
    }

    private Device getDevice() {
        if (this.device == null) {
            Control control = this.getControl();
            if (control != null && !control.isDisposed()) {
                this.device = control.getDisplay();
            }
            if (this.device == null) {
                this.device = Display.getCurrent();
            }
        }
        return this.device;
    }

    public void dispose() {
        for (ImageCache cache : this.caches.values()) {
            cache.dispose();
        }
        this.caches.clear();
        super.dispose();
    }

    private class ImageCache {
        ImageDescriptor descriptor;
        Image image;
        private List<Object> references = null;

        public ImageCache(ImageDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public Image getImage(boolean returnMissingImageOnError, Object reference) {
            if (this.image == null) {
                this.image = this.descriptor.createImage(returnMissingImageOnError, ImageRegistryService.this.getDevice());
            }
            if (reference != null) {
                if (this.references == null) {
                    this.references = new ArrayList<Object>();
                }
                this.references.add(reference);
            }
            return this.image;
        }

        public void decreaseRef(Object reference) {
            if (this.references != null && reference != null) {
                this.references.remove(reference);
                if (!this.hasReferences()) {
                    this.dispose();
                }
            }
        }

        public void dispose() {
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
            this.references = null;
        }

        public boolean hasReferences() {
            return this.references != null && !this.references.isEmpty();
        }
    }
}

