/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IZoomListener;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.ZoomObject;
import org.xmind.gef.draw2d.IRotatableFigure;
import org.xmind.gef.draw2d.SelectionFigure;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.geometry.PrecisionRotator;
import org.xmind.gef.service.GraphicalViewerService;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IFeedbackService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedbackService
extends GraphicalViewerService
implements IZoomListener,
FocusListener,
FigureListener,
IFeedbackService {
    private static final List<IFeedback> NO_FEEDBACK = Collections.emptyList();
    private IFigure layer;
    private ZoomManager zoom;
    private List<IFeedback> feedbacks = null;
    private Map<IFigure, SelectionFigure> selections = new HashMap<IFigure, SelectionFigure>();
    private IColorProvider selectionColorProvider = null;
    private int selectionLineWidth = 2;
    private int selectionCorner = 5;

    public FeedbackService(IGraphicalViewer viewer) {
        super(viewer);
    }

    public int getSelectionCorner() {
        return this.selectionCorner;
    }

    public void setSelectionCorner(int selectionCorner) {
        this.selectionCorner = selectionCorner;
    }

    public int getSelectionLineWidth() {
        return this.selectionLineWidth;
    }

    public void setSelectionLineWidth(int selectionLineWidth) {
        this.selectionLineWidth = selectionLineWidth;
    }

    @Override
    public List<IFeedback> getFeedbackParts() {
        if (this.feedbacks == null) {
            return NO_FEEDBACK;
        }
        return this.feedbacks;
    }

    @Override
    protected void activate() {
        this.setZoomManager(this.getViewer().getZoomManager());
    }

    @Override
    protected void deactivate() {
        this.setZoomManager(null);
    }

    @Override
    protected void hookControl(Control control) {
        control.addFocusListener((FocusListener)this);
    }

    @Override
    protected void unhookControl(Control canvas) {
        canvas.removeFocusListener((FocusListener)this);
    }

    @Override
    public void setLayer(IFigure layer) {
        block2: {
            IFigure oldLayer;
            block3: {
                oldLayer = this.layer;
                this.layer = layer;
                if (this.feedbacks == null) break block2;
                if (oldLayer != null || layer == null) break block3;
                for (IFeedback part : this.feedbacks) {
                    part.addToLayer(layer);
                    part.update();
                }
                break block2;
            }
            if (oldLayer == null || layer != null) break block2;
            for (IFeedback part : this.feedbacks) {
                part.removeFromLayer(oldLayer);
            }
        }
    }

    public void focusGained(FocusEvent e) {
        Display display;
        if (this.getControl() != null && !this.getControl().isDisposed() && (display = this.getControl().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (FeedbackService.this.getControl() != null && !FeedbackService.this.getControl().isDisposed()) {
                        FeedbackService.this.refresh();
                    }
                }
            });
        }
    }

    public void focusLost(FocusEvent e) {
        Display display;
        if (this.getControl() != null && !this.getControl().isDisposed() && (display = this.getControl().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (FeedbackService.this.getControl() != null && !FeedbackService.this.getControl().isDisposed()) {
                        FeedbackService.this.refresh();
                    }
                }
            });
        }
    }

    private void setZoomManager(ZoomManager zoom) {
        if (this.zoom == zoom) {
            return;
        }
        if (this.zoom != null) {
            this.zoom.removeZoomListener(this);
        }
        this.zoom = zoom;
        if (this.zoom != null) {
            this.zoom.addZoomListener(this);
        }
        this.refresh();
    }

    @Override
    public void scaleChanged(ZoomObject source, double oldValue, double newValue) {
        if (this.isActive() && !this.isDisposed()) {
            this.updateAllFeedback();
            this.updateAllSelections();
        }
    }

    public void refresh() {
        if (this.isActive() && !this.isDisposed()) {
            this.updateAllFeedback();
            this.updateAllSelections();
            this.updateSelectionColors();
        }
    }

    private void updateAllFeedback() {
        if (this.feedbacks != null) {
            Object[] objectArray = this.feedbacks.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ((IFeedback)o).update();
                ++n2;
            }
        }
    }

    private void updateAllSelections() {
        for (IFigure source : this.selections.keySet()) {
            this.updateSelection(source);
        }
    }

    @Override
    public void addFeedback(IFeedback feedback) {
        if (feedback == null) {
            return;
        }
        if (this.feedbacks != null && this.feedbacks.contains(feedback)) {
            return;
        }
        if (this.feedbacks == null) {
            this.feedbacks = new ArrayList<IFeedback>();
        }
        this.feedbacks.add(feedback);
        feedback.setZoomManager(this.zoom);
        if (this.layer != null) {
            feedback.addToLayer(this.layer);
        }
        feedback.update();
    }

    @Override
    public void removeFeedback(IFeedback feedback) {
        if (feedback == null) {
            return;
        }
        if (this.feedbacks == null || !this.feedbacks.contains(feedback)) {
            return;
        }
        if (this.layer != null) {
            feedback.removeFromLayer(this.layer);
        }
        feedback.setZoomManager(null);
        this.feedbacks.remove(feedback);
    }

    @Override
    public void setSelectionColorProvider(IColorProvider selectionColorProvider) {
        this.selectionColorProvider = selectionColorProvider;
    }

    @Override
    public IColorProvider getSelectionColorProvider() {
        return this.selectionColorProvider;
    }

    @Override
    public SelectionFigure addSelection(IFigure source) {
        this.removeSelection(source);
        if (this.layer == null) {
            return null;
        }
        SelectionFigure selection = this.createSelectionFigure();
        this.selections.put(source, selection);
        this.updateSelection(source);
        this.layer.add((IFigure)selection);
        source.addFigureListener((FigureListener)this);
        return selection;
    }

    private void updateSelectionColors() {
        IColorProvider colorProvider = this.getSelectionColorProvider();
        if (colorProvider != null) {
            Color preselectionFillColor;
            Color selectionFillColor;
            Color focusFillColor;
            Color preselectionColor;
            Color selectionColor;
            Color focusColor;
            boolean disabled;
            boolean bl = disabled = this.getControl() != null && !this.getControl().isDisposed() && !this.getControl().isFocusControl();
            if (disabled) {
                focusColor = colorProvider.getForeground(DisabledFocusColor);
                selectionColor = colorProvider.getForeground(DisabledSelectionColor);
                preselectionColor = colorProvider.getForeground(DisabledPreselectionColor);
                focusFillColor = colorProvider.getBackground(DisabledFocusColor);
                selectionFillColor = colorProvider.getBackground(DisabledSelectionColor);
                preselectionFillColor = colorProvider.getBackground(DisabledPreselectionColor);
            } else {
                focusColor = colorProvider.getForeground(FocusColor);
                selectionColor = colorProvider.getForeground(SelectionColor);
                preselectionColor = colorProvider.getForeground(PreselectionColor);
                focusFillColor = colorProvider.getBackground(FocusColor);
                selectionFillColor = colorProvider.getBackground(SelectionColor);
                preselectionFillColor = colorProvider.getBackground(PreselectionColor);
            }
            for (SelectionFigure f : this.selections.values()) {
                f.setFocusColor(focusColor);
                f.setSelectionColor(selectionColor);
                f.setPreselectionColor(preselectionColor);
                f.setFocusFillColor(focusFillColor);
                f.setSelectionFillColor(selectionFillColor);
                f.setPreselectionFillColor(preselectionFillColor);
            }
        }
    }

    private SelectionFigure createSelectionFigure() {
        SelectionFigure f = new SelectionFigure();
        IColorProvider colorProvider = this.getSelectionColorProvider();
        if (colorProvider != null) {
            Color preselectionFillColor;
            Color selectionFillColor;
            Color focusFillColor;
            Color preselectionColor;
            Color selectionColor;
            Color focusColor;
            boolean disabled;
            boolean bl = disabled = this.getControl() != null && !this.getControl().isDisposed() && !this.getControl().isFocusControl();
            if (disabled) {
                focusColor = colorProvider.getForeground(DisabledFocusColor);
                selectionColor = colorProvider.getForeground(DisabledSelectionColor);
                preselectionColor = colorProvider.getForeground(DisabledPreselectionColor);
                focusFillColor = colorProvider.getBackground(DisabledFocusColor);
                selectionFillColor = colorProvider.getBackground(DisabledSelectionColor);
                preselectionFillColor = colorProvider.getBackground(DisabledPreselectionColor);
            } else {
                focusColor = colorProvider.getForeground(FocusColor);
                selectionColor = colorProvider.getForeground(SelectionColor);
                preselectionColor = colorProvider.getForeground(PreselectionColor);
                focusFillColor = colorProvider.getBackground(FocusColor);
                selectionFillColor = colorProvider.getBackground(SelectionColor);
                preselectionFillColor = colorProvider.getBackground(PreselectionColor);
            }
            f.setFocusColor(focusColor);
            f.setSelectionColor(selectionColor);
            f.setPreselectionColor(preselectionColor);
            f.setFocusFillColor(focusFillColor);
            f.setSelectionFillColor(selectionFillColor);
            f.setPreselectionFillColor(preselectionFillColor);
        }
        f.setLineWidth(this.selectionLineWidth);
        return f;
    }

    @Override
    public SelectionFigure removeSelection(IFigure source) {
        SelectionFigure old = this.selections.remove(source);
        if (old != null && old.getParent() == this.layer) {
            if (this.layer != null) {
                this.layer.remove((IFigure)old);
            }
            this.disposeSelection(old);
        }
        source.removeFigureListener((FigureListener)this);
        return old;
    }

    @Override
    public SelectionFigure getSelectionFigure(IFigure source) {
        SelectionFigure figure = this.selections.get(source);
        return figure == null ? this.addSelection(source) : figure;
    }

    @Override
    public SelectionFigure setSelected(IFigure source) {
        SelectionFigure figure = this.getSelectionFigure(source);
        if (figure != null) {
            figure.setFocused(false);
            figure.setPreselected(false);
            figure.setSelected(true);
        }
        return figure;
    }

    @Override
    public SelectionFigure setPreselected(IFigure source) {
        SelectionFigure figure = this.getSelectionFigure(source);
        if (figure != null) {
            figure.setFocused(false);
            figure.setSelected(false);
            figure.setPreselected(true);
        }
        return figure;
    }

    @Override
    public SelectionFigure setFocused(IFigure source) {
        SelectionFigure figure = this.getSelectionFigure(source);
        if (figure != null) {
            figure.setSelected(false);
            figure.setPreselected(false);
            figure.setFocused(true);
        }
        return figure;
    }

    public void figureMoved(IFigure source) {
        this.updateSelection(source);
    }

    private void updateSelection(IFigure source) {
        SelectionFigure selection = this.selections.get(source);
        if (selection != null) {
            this.disposeSelection(selection);
            org.xmind.gef.draw2d.graphics.Path p = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
            int lineWidth = this.selectionLineWidth;
            if (this.zoom != null && (lineWidth = (int)((double)lineWidth * this.zoom.getScale())) < 2) {
                lineWidth = 2;
            }
            selection.setLineWidth(lineWidth);
            int exp = lineWidth;
            double halfExp = this.aZoom((double)exp * 0.5 + 0.5);
            PrecisionRectangle bounds = new PrecisionRectangle(source.getBounds());
            if ("win32".equals(SWT.getPlatform())) {
                bounds.resize(-1.0, -1.0);
            }
            if (source instanceof IRotatableFigure && ((IRotatableFigure)source).getRotationDegrees() != 0.0) {
                IRotatableFigure rf = (IRotatableFigure)source;
                PrecisionDimension size = rf.getNormalPreferredSize(-1, -1);
                PrecisionPoint c = bounds.getCenter();
                PrecisionRotator r = new PrecisionRotator(c);
                r.setAngle(rf.getRotationDegrees());
                PrecisionRectangle b = r.r(bounds, -1.0, size.height);
                b.expand(halfExp, halfExp);
                p.addRoundedPolygon((float)this.selectionCorner, this.zoom(r.t(b.getTopLeft())), this.zoom(r.t(b.getTopRight())), this.zoom(r.t(b.getBottomRight())), this.zoom(r.t(b.getBottomLeft())));
            } else {
                p.addRoundedRectangle(this.zoom(bounds.expand(halfExp, halfExp)), (float)this.selectionCorner);
            }
            selection.setPath(p);
            selection.setBounds(selection.getPreferredBounds());
        }
    }

    private double aZoom(double d) {
        return this.zoom == null ? d : d / this.zoom.getScale();
    }

    private PrecisionPoint zoom(PrecisionPoint p) {
        return this.zoom == null ? p : p.scale(this.zoom.getScale());
    }

    private PrecisionRectangle zoom(PrecisionRectangle r) {
        return this.zoom == null ? r : r.scale(this.zoom.getScale());
    }

    private void disposeSelection(SelectionFigure s) {
        Path p = s.getPath();
        if (p != null && !p.isDisposed()) {
            s.setPath(null);
            p.dispose();
        }
    }

    @Override
    public void dispose() {
        if (this.selections != null) {
            Object[] objectArray = this.selections.keySet().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                this.removeSelection((IFigure)key);
                ++n2;
            }
            this.selections.clear();
        }
        super.dispose();
    }

    public void addSkylight(IFigure figure) {
    }

    public void removeSkylight(IFigure figure) {
    }
}

