/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.part;

import org.xmind.gef.EditDomain;
import org.xmind.gef.Request;
import org.xmind.gef.acc.AccessibleRegistry;
import org.xmind.gef.acc.IAccessible;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.part.Part;
import org.xmind.gef.part.RequestHandler;

public class EditPart
extends Part {
    private IAccessible accessible = null;
    private IRequestHandler requestHandler = null;

    protected void register() {
        super.register();
        this.registerAccessible();
        this.declareEditPolicies(this.getRequestHandler());
    }

    protected void unregister() {
        super.unregister();
        this.unregisterAccessible();
    }

    protected void registerAccessible() {
        AccessibleRegistry accRegistry;
        IAccessible acc = this.getAccessible();
        if (acc != null && (accRegistry = this.getSite().getViewer().getAccessibleRegistry()) != null) {
            accRegistry.register(acc);
        }
    }

    protected void unregisterAccessible() {
        AccessibleRegistry accRegistry;
        IAccessible acc = this.getAccessible();
        if (acc != null && (accRegistry = this.getSite().getViewer().getAccessibleRegistry()) != null) {
            accRegistry.unregister(acc);
        }
    }

    protected IAccessible getAccessible() {
        return this.accessible;
    }

    protected void setAccessible(IAccessible accessible) {
        if (accessible == null || this.accessible != null) {
            return;
        }
        this.accessible = accessible;
    }

    protected void installModelListeners() {
    }

    protected void uninstallModelListeners() {
    }

    public IRequestHandler getRequestHandler() {
        if (this.requestHandler == null) {
            this.requestHandler = new RequestHandler(this);
        }
        return this.requestHandler;
    }

    public void setRequestHandler(IRequestHandler requestProcessor) {
        this.requestHandler = requestProcessor;
    }

    protected void onActivated() {
        this.installModelListeners();
        super.onActivated();
    }

    protected void onDeactivated() {
        super.onDeactivated();
        this.uninstallModelListeners();
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
    }

    protected void sendRequest(String reqType) {
        this.sendRequest(new Request(reqType).setPrimaryTarget(this));
    }

    protected void sendRequest(Request request) {
        EditDomain domain = this.getSite().getDomain();
        if (domain == null) {
            return;
        }
        domain.handleRequest(request.setDomain(domain).setViewer(this.getSite().getViewer()));
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IAccessible.class) {
            return this.getAccessible();
        }
        if (adapter == IRequestHandler.class) {
            return this.getRequestHandler();
        }
        return super.getAdapter(adapter);
    }

    public boolean hasRole(String role) {
        if (this.requestHandler != null) {
            return this.requestHandler.hasRole(role);
        }
        return super.hasRole(role);
    }

    public void handleRequest(Request request, String role) {
        if (this.requestHandler != null) {
            this.requestHandler.handleRequest(request, role);
        }
    }
}

