/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.internal.image;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.image.ExportAreaProvider;

public class ConstrainedExportAreaProvider
extends ExportAreaProvider {
    public ConstrainedExportAreaProvider(IFigure figure, Rectangle sourceArea, int constrainedWidth, int constrainedHeight, Insets margins) {
        super(figure, sourceArea, constrainedWidth, constrainedHeight, margins);
    }

    protected void adjustExportArea() {
        if (this.constrainedWidth >= 0 && this.constrainedHeight >= 0) {
            if (this.constrainedWidth > 0 && this.constrainedHeight > 0) {
                if (this.exportArea.width > 0 && this.exportArea.height > 0) {
                    double w = this.constrainedWidth - this.margins.getWidth();
                    double h = this.constrainedHeight - this.margins.getHeight();
                    if (w < 0.0) {
                        w = 0.0;
                        this.margins.right = 0;
                        this.margins.left = 0;
                    }
                    if (h < 0.0) {
                        h = 0.0;
                        this.margins.bottom = 0;
                        this.margins.top = 0;
                    }
                    if (w < (double)this.exportArea.width && h < (double)this.exportArea.height) {
                        double sx = w / (double)this.exportArea.width;
                        double sy = h / (double)this.exportArea.height;
                        if (sx > sy) {
                            this.scale = sy;
                            this.exportArea.scale(this.scale).expand(this.margins);
                            this.exportArea.height = this.constrainedHeight;
                        } else if (sx < sy) {
                            this.scale = sx;
                            this.exportArea.scale(this.scale).expand(this.margins);
                            this.exportArea.width = this.constrainedWidth;
                        }
                    } else if (h < (double)this.exportArea.height) {
                        this.scale = h / (double)this.exportArea.height;
                        this.exportArea.scale(this.scale).expand(this.margins);
                        this.exportArea.height = this.constrainedHeight;
                    } else if (w < (double)this.exportArea.width) {
                        this.scale = w / (double)this.exportArea.width;
                        this.exportArea.scale(this.scale).expand(this.margins);
                        this.exportArea.width = this.constrainedWidth;
                    } else {
                        this.exportArea.expand(this.margins);
                    }
                }
            } else {
                this.scale = 0.0;
            }
        } else if (this.constrainedWidth >= 0) {
            if (this.exportArea.width > 0) {
                double w = this.constrainedWidth - this.margins.getWidth();
                if (w < 0.0) {
                    w = 0.0;
                    this.margins.right = 0;
                    this.margins.left = 0;
                }
                if (w < (double)this.exportArea.width) {
                    this.scale = w / (double)this.exportArea.width;
                    this.exportArea.scale(this.scale).expand(this.margins);
                    this.exportArea.width = this.constrainedWidth;
                } else {
                    this.exportArea.expand(this.margins);
                }
            } else {
                this.scale = 0.0;
            }
        } else if (this.constrainedHeight >= 0) {
            if (this.exportArea.height > 0) {
                double h = this.constrainedHeight - this.margins.getHeight();
                if (h < 0.0) {
                    h = 0.0;
                    this.margins.bottom = 0;
                    this.margins.top = 0;
                }
                if (h < (double)this.exportArea.height) {
                    this.scale = h / (double)this.exportArea.height;
                    this.exportArea.scale(this.scale).expand(this.margins);
                    this.exportArea.height = this.constrainedHeight;
                } else {
                    this.exportArea.expand(this.margins);
                }
            } else {
                this.scale = 0.0;
            }
        } else {
            this.exportArea.expand(this.margins);
        }
    }
}

