/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.geometry;

import org.eclipse.draw2d.geometry.Dimension;

public class PrecisionDimension {
    private static final long serialVersionUID = -8002279770296919048L;
    public double width;
    public double height;

    public PrecisionDimension() {
    }

    public PrecisionDimension(Dimension d) {
        this.width = d.width;
        this.height = d.height;
    }

    public PrecisionDimension(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public PrecisionDimension(PrecisionDimension d) {
        this.width = d.width;
        this.height = d.height;
    }

    public PrecisionDimension transpose() {
        double temp = this.width;
        this.width = this.height;
        this.height = temp;
        return this;
    }

    public PrecisionDimension negate() {
        this.width = 0.0 - this.width;
        this.height = 0.0 - this.height;
        return this;
    }

    public PrecisionDimension expand(double w, double h) {
        this.width += w;
        this.height += h;
        return this;
    }

    public PrecisionDimension union(PrecisionDimension d) {
        this.width = Math.max(this.width, d.width);
        this.height = Math.max(this.height, d.height);
        return this;
    }

    public Dimension toDraw2DDimension() {
        return new Dimension((int)Math.floor(this.width + 1.0E-9), (int)Math.floor(this.height + 1.0E-9));
    }

    public Dimension toBiggerDraw2DDimension() {
        return new Dimension((int)Math.ceil(this.width), (int)Math.ceil(this.height));
    }

    public PrecisionDimension scale(double factor) {
        return this.scale(factor, factor);
    }

    public PrecisionDimension scale(double wScale, double hScale) {
        this.width *= wScale;
        this.height *= hScale;
        return this;
    }

    public PrecisionDimension getCopy() {
        return new PrecisionDimension(this.width, this.height);
    }

    public PrecisionDimension getScale(double factor) {
        return this.getCopy().scale(factor);
    }

    public PrecisionDimension getScale(double wScale, double hScale) {
        return this.getCopy().scale(wScale, hScale);
    }

    public double getDiagonal() {
        return Math.sqrt(this.getDiagonal2());
    }

    public double getDiagonal2() {
        return this.width * this.width + this.height * this.height;
    }

    public PrecisionDimension setSize(double width, double height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public PrecisionDimension setSize(PrecisionDimension d) {
        return this.setSize(d.width, d.height);
    }

    public String toString() {
        return "PrecisionDimensin(" + this.width + "," + this.height + ")";
    }
}

