/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class SimpleLineFigure
extends Figure {
    public Point source;
    public Point target;
    private int alpha = 255;
    private int lineWidth = 1;

    public SimpleLineFigure() {
        this.source = new Point(0, 0);
        this.target = new Point(0, 0);
        this.pack();
    }

    public SimpleLineFigure(Point source, Point target) {
        this.source = source.getCopy();
        this.target = target.getCopy();
        this.pack();
    }

    public void pack() {
        this.setBounds(Rectangle.SINGLETON.setLocation(this.source).setSize(0, 0).union(this.target.x, this.target.y).expand(this.getLineWidth(), this.getLineWidth()));
        this.repaint();
    }

    public void setLocations(Point source, Point target) {
        this.source.setLocation(source);
        this.target.setLocation(target);
        this.pack();
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (alpha == this.alpha) {
            return;
        }
        this.alpha = alpha;
        this.repaint();
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        if (lineWidth == this.lineWidth) {
            return;
        }
        this.lineWidth = lineWidth;
        this.pack();
        this.repaint();
    }

    protected void paintFigure(Graphics graphics) {
        Color c = this.getLocalForegroundColor();
        if (c != null && this.alpha > 0) {
            graphics.setAntialias(1);
            graphics.setAlpha(this.alpha);
            graphics.setForegroundColor(c);
            graphics.setLineStyle(1);
            graphics.setLineWidth(this.getLineWidth());
            graphics.drawLine(this.source, this.target);
        }
    }
}

