/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.command;

import java.util.ArrayList;
import java.util.List;
import org.xmind.gef.Disposable;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CommandStackEvent;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.command.ICommandStackListener;

public abstract class CommandStackBase
extends Disposable
implements ICommandStack {
    public static int DEFAULT_UNDO_LIMIT = 20;
    private List<ICommandStackListener> commandStackListeners = null;
    private int undoLimit;

    public CommandStackBase(int undoLimit) {
        this.undoLimit = undoLimit;
    }

    public CommandStackBase() {
        this(DEFAULT_UNDO_LIMIT);
    }

    public void addCSListener(ICommandStackListener listener) {
        if (this.commandStackListeners == null) {
            this.commandStackListeners = new ArrayList<ICommandStackListener>();
        }
        this.commandStackListeners.add(listener);
    }

    public void removeCSListener(ICommandStackListener listener) {
        if (this.commandStackListeners == null) {
            return;
        }
        this.commandStackListeners.remove(listener);
    }

    protected void fireEvent(int status) {
        if (this.commandStackListeners == null) {
            return;
        }
        this.fireEvent(new CommandStackEvent(this, status));
    }

    protected void fireEvent(Command cmd, int status) {
        if (this.commandStackListeners == null) {
            return;
        }
        this.fireEvent(new CommandStackEvent(this, cmd, status));
    }

    protected void fireEvent(CommandStackEvent event) {
        if (this.commandStackListeners == null) {
            return;
        }
        Object[] objectArray = this.commandStackListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ICommandStackListener)listener).handleCommandStackEvent(event);
            ++n2;
        }
    }

    public void dispose() {
        if (this.commandStackListeners != null) {
            this.commandStackListeners.clear();
            this.commandStackListeners = null;
        }
        this.clear();
        super.dispose();
    }

    public int getUndoLimit() {
        return this.undoLimit;
    }

    public void setUndoLimit(int undoLimit) {
        this.undoLimit = undoLimit;
    }

    public String getRepeatLabel() {
        return this.getUndoLabel();
    }

    public boolean canRepeat() {
        return false;
    }

    public void repeat() {
    }

    public void markSaved() {
    }

    public boolean isDirty() {
        return this.canUndo();
    }
}

