/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.fishbone.structures;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.IRotatableReferencedFigure;
import org.xmind.gef.draw2d.ReferencedLayoutData;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.HorizontalFlipper;
import org.xmind.gef.draw2d.geometry.ITransformer;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionLine;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.branch.BoundaryLayoutHelper;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.branch.Insertion;
import org.xmind.ui.internal.fishbone.structures.FishboneData;
import org.xmind.ui.internal.fishbone.structures.ISubDirection;
import org.xmind.ui.internal.fishbone.structures.SubFishboneData;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.INodePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ParentSearchKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubFishboneStructure
extends AbstractBranchStructure {
    private ISubDirection direction;
    private ITransformer t = new HorizontalFlipper();

    public SubFishboneStructure(ISubDirection direction) {
        this.direction = direction;
        this.t.setEnabled(false);
    }

    private double getPadding(IBranchPart branch) {
        return this.getCastedData(branch).getPadding();
    }

    public void fillLayoutData(IBranchPart branch, ReferencedLayoutData data) {
        super.fillLayoutData(branch, data);
        data.addMargins(new Insets((int)Math.ceil(this.getPadding(branch))));
    }

    protected void doFillPlusMinus(IBranchPart branch, IPlusMinusPart plusMinus, AbstractBranchStructure.LayoutInfo info) {
        Point ref = info.getReference();
        SubFishboneData fd = this.getCastedData(branch);
        fd.r1.setOrigin((double)ref.x, (double)ref.y);
        IFigure figure = plusMinus.getFigure();
        Dimension size = figure.getPreferredSize();
        PrecisionRectangle topicBounds = this.getNormalTopicBounds(branch, ref);
        int orientation = this.getSourceOrientation(branch);
        double halfWidth = (double)size.width * 0.5;
        double halfHeight = (double)size.height * 0.5;
        double centerX = orientation == 8 ? topicBounds.x - halfWidth : topicBounds.right() + halfWidth;
        PrecisionPoint center = fd.r1.tp(new PrecisionPoint(centerX, (double)ref.y));
        Point loc = center.translate(-halfWidth, -halfHeight).toDraw2DPoint();
        info.put(figure, new Rectangle(loc, size));
    }

    private PrecisionRectangle getNormalTopicBounds(IBranchPart branch, Point ref) {
        IFigure figure;
        ITopicPart topic = branch.getTopicPart();
        if (topic != null && (figure = topic.getFigure()) instanceof IRotatableReferencedFigure) {
            return ((IRotatableReferencedFigure)figure).getNormalPreferredBounds(ref);
        }
        return new PrecisionRectangle((double)ref.x, (double)ref.y, 0.0, 0.0);
    }

    protected BoundaryLayoutHelper getBoundaryLayoutHelper(IBranchPart branch) {
        return super.getBoundaryLayoutHelper(branch);
    }

    protected void doFillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
        Point ref = info.getReference();
        FishboneData fd = this.getCastedData(branch).getFishboneData();
        for (IBranchPart subBranch : subBranches) {
            IFigure figure = subBranch.getFigure();
            Rectangle rect = fd.getChildPrefBounds(subBranch, new PrecisionPoint(ref));
            if (rect == null) continue;
            info.put(figure, rect);
        }
    }

    protected Object createStructureData(IBranchPart branch) {
        return new SubFishboneData(branch, this.direction);
    }

    protected boolean isValidStructureData(IBranchPart branch, Object data) {
        return super.isValidStructureData(branch, data) && data instanceof SubFishboneData;
    }

    protected SubFishboneData getCastedData(IBranchPart branch) {
        return (SubFishboneData)((Object)super.getStructureData(branch));
    }

    public int calcChildDistance(IBranchPart branch, ParentSearchKey key) {
        PrecisionLine boneLine = this.getBoneLine(branch);
        PrecisionPoint source = this.calcSourceLocation(branch, boneLine);
        PrecisionLine sourceRay = this.getBoneRay(source);
        List subBranches = branch.getSubBranches();
        boolean folded = branch.isFolded();
        PrecisionLine childBoneLine = this.getChildBoneLine(branch, key.getFeedback());
        double offset = this.calcChildOffset(boneLine, sourceRay, childBoneLine);
        if (offset > 0.0) {
            double distance;
            double range;
            if (!subBranches.isEmpty() && !folded) {
                int lastIndex = this.direction.isChildrenTraverseReversed() ? 0 : subBranches.size() - 1;
                IBranchPart lastChild = (IBranchPart)subBranches.get(lastIndex);
                double lastOffset = this.calcChildOffset(boneLine, sourceRay, this.getChildBoneLine(branch, lastChild));
                range = lastOffset + 200.0;
            } else {
                range = 200.0;
            }
            if (offset < range && (distance = this.calcChildDistance(boneLine, childBoneLine)) > 0.0 && distance < 200.0) {
                return Math.max(1, (int)distance);
            }
        }
        return super.calcChildDistance(branch, key);
    }

    private double calcChildDistance(PrecisionLine boneLine, PrecisionLine childLine) {
        PrecisionPoint target = childLine.getOrigin();
        PrecisionLine.Side childSide = boneLine.getSide(target);
        if (this.needsCalcChildDistance(childSide)) {
            return Geometry.getDistance((PrecisionPoint)target, (PrecisionLine)boneLine);
        }
        return -1.0;
    }

    private double calcChildOffset(PrecisionLine boneLine, PrecisionLine sourceRay, PrecisionLine childLine) {
        PrecisionPoint joint = boneLine.intersect(childLine);
        PrecisionDimension offset = joint.getDifference(sourceRay.getOrigin());
        double off = offset.getDiagonal();
        if (!sourceRay.contains(joint)) {
            off = -off;
        }
        return off;
    }

    private boolean needsCalcChildDistance(PrecisionLine.Side childSide) {
        if (childSide == PrecisionLine.Side.Right) {
            return this.direction == ISubDirection.NER || this.direction == ISubDirection.SE || this.direction == ISubDirection.NW || this.direction == ISubDirection.SWR;
        }
        if (childSide == PrecisionLine.Side.Left) {
            return this.direction == ISubDirection.NE || this.direction == ISubDirection.SER || this.direction == ISubDirection.NWR || this.direction == ISubDirection.SW;
        }
        return false;
    }

    private PrecisionLine getBoneLine(IBranchPart branch) {
        IAnchor anchor = ((INodePart)branch.getTopicPart()).getSourceAnchor((IGraphicalPart)branch);
        int orientation = this.getSourceOrientation(branch);
        PrecisionPoint p1 = anchor.getLocation(Geometry.getOppositePosition((int)orientation), 0.0);
        PrecisionPoint p2 = anchor.getLocation(orientation, 0.0);
        return new PrecisionLine(p1, p2, PrecisionLine.LineType.Line);
    }

    private PrecisionLine getChildBoneLine(IBranchPart branch, IBranchPart child) {
        IAnchor anchor = ((INodePart)child.getTopicPart()).getTargetAnchor((IGraphicalPart)branch);
        int orientation = this.getChildTargetOrientation(branch, child);
        PrecisionPoint p1 = anchor.getLocation(orientation, 0.0);
        double angle = this.direction.getSubDirection().getRotateAngle();
        PrecisionPoint p2 = p1.getMoved(Math.toRadians(angle), 100.0);
        return new PrecisionLine(p1, p2, PrecisionLine.LineType.Line);
    }

    private PrecisionPoint calcSourceLocation(IBranchPart branch, PrecisionLine boneLine) {
        if (!branch.getSubBranches().isEmpty() && !branch.isFolded() && this.direction.isRotated()) {
            PrecisionPoint ref = new PrecisionPoint(((IReferencedFigure)branch.getTopicPart().getFigure()).getReference());
            PrecisionPoint p = ref.getMoved(Math.toRadians(-this.direction.getRotateAngle()), 100.0);
            return boneLine.intersect(new PrecisionLine(ref, p, PrecisionLine.LineType.Line));
        }
        return ((INodePart)branch.getTopicPart()).getSourceAnchor((IGraphicalPart)branch).getLocation(this.getSourceOrientation(branch), 0.0);
    }

    private PrecisionLine getBoneRay(PrecisionPoint p) {
        double angle = this.direction.getRotateAngle();
        if (this.direction == ISubDirection.SER || this.direction == ISubDirection.NWR || this.direction == ISubDirection.NW || this.direction == ISubDirection.SW) {
            angle += 180.0;
        }
        return new PrecisionLine(p, p.getMoved(Math.toRadians(angle), 100.0), PrecisionLine.LineType.Ray);
    }

    public int calcChildIndex(IBranchPart branch, ParentSearchKey key) {
        return this.calcInsIndex(branch, key.getFeedback(), false);
    }

    public IInsertion calcInsertion(IBranchPart branch, ParentSearchKey key) {
        return new Insertion(branch, this.calcInsIndex(branch, key.getFeedback(), true), key.getFigure().getSize());
    }

    private int calcInsIndex(IBranchPart branch, IBranchPart child, boolean withDisabled) {
        if (branch.getSubBranches().isEmpty() || branch.isFolded()) {
            return withDisabled ? 0 : -1;
        }
        PrecisionLine boneLine = this.getBoneLine(branch);
        PrecisionPoint source = this.calcSourceLocation(branch, boneLine);
        PrecisionLine sourceRay = this.getBoneRay(source);
        double offset = this.calcChildOffset(boneLine, sourceRay, this.getChildBoneLine(branch, child));
        boolean reversed = this.direction.isChildrenTraverseReversed();
        List subBranches = branch.getSubBranches();
        int num = subBranches.size();
        int ret = 0;
        for (IBranchPart subBranch : subBranches) {
            double subOffset = this.calcChildOffset(boneLine, sourceRay, this.getChildBoneLine(branch, subBranch));
            if (reversed ? offset > subOffset : offset < subOffset) {
                return ret;
            }
            if (!withDisabled && !subBranch.getFigure().isEnabled()) continue;
            ++ret;
        }
        return withDisabled ? num : -1;
    }

    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        if (this.direction.isRotated()) {
            if ("navigate up".equals(navReqType)) {
                return this.getSubTopicPart(branch, sourceChild.getBranchIndex() - 1);
            }
            if ("navigate down".equals(navReqType)) {
                return this.getSubTopicPart(branch, sourceChild.getBranchIndex() + 1);
            }
            if (!sequential && (this.direction.isRightHeaded() ? "navigate right".equals(navReqType) : "navigate left".equals(navReqType))) {
                return branch.getTopicPart();
            }
        } else {
            String nextType;
            String prevType = this.direction.isRightHeaded() ? "navigate right" : "navigate left";
            String string = nextType = this.direction.isRightHeaded() ? "navigate left" : "navigate right";
            if (prevType.equals(navReqType)) {
                ITopicPart prev = this.getSubTopicPart(branch, sourceChild.getBranchIndex() - 1);
                if (prev == null && !sequential) {
                    return branch.getTopicPart();
                }
                return prev;
            }
            if (nextType.equals(navReqType)) {
                return this.getSubTopicPart(branch, sourceChild.getBranchIndex() + 1);
            }
        }
        return super.calcChildNavigation(branch, sourceChild, navReqType, sequential);
    }

    public IPart calcNavigation(IBranchPart branch, String navReqType) {
        if (this.isNavChild(branch, navReqType)) {
            if (this.direction.isChildrenTraverseReversed()) {
                return this.getSubTopicPart(branch, branch.getSubBranches().size() - 1);
            }
            return this.getSubTopicPart(branch, 0);
        }
        return super.calcNavigation(branch, navReqType);
    }

    private boolean isNavChild(IBranchPart branch, String navReqType) {
        if (this.direction.isRotated() && (this.direction.isDownwards() ? "navigate down".equals(navReqType) : "navigate up".equals(navReqType))) {
            return true;
        }
        if (this.direction.isRightHeaded()) {
            return "navigate left".equals(navReqType);
        }
        return "navigate right".equals(navReqType);
    }

    public int getChildTargetOrientation(IBranchPart branch, IBranchPart subBranch) {
        if (!branch.getSubBranches().contains(subBranch)) {
            return this.direction.isRightHeaded() ? 16 : 8;
        }
        return this.direction.getChildTargetOrientation();
    }

    public int getSourceOrientation(IBranchPart branch) {
        return this.direction.getSourceOrientation();
    }

    public int getRangeGrowthDirection(IBranchPart branch, IBranchRangePart range) {
        return this.getRangeGrowthDirection();
    }

    private int getRangeGrowthDirection() {
        if (this.direction.isRotated()) {
            return 4;
        }
        return this.direction.isRightHeaded() ? 16 : 8;
    }

    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        if (this.direction.isRotated()) {
            return this.direction.isRightHeaded() ? 16 : 16;
        }
        return this.direction.isDownwards() ? 4 : 1;
    }

    public int getQuickMoveOffset(IBranchPart branch, IBranchPart child, int direction) {
        int rangeGrowthDirection = this.getRangeGrowthDirection();
        if (direction == rangeGrowthDirection) {
            return 1;
        }
        if (direction == Geometry.getOppositePosition((int)rangeGrowthDirection)) {
            return -1;
        }
        return super.getQuickMoveOffset(branch, child, direction);
    }
}

