/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.fishbone.structures;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.geometry.IPrecisionTransformer;
import org.xmind.gef.draw2d.geometry.PrecisionInsets;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.geometry.PrecisionRotator;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.BoundaryLayoutHelper;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.internal.fishbone.structures.AbstractSubFishboneDirection;
import org.xmind.ui.internal.fishbone.structures.FishboneData;
import org.xmind.ui.internal.fishbone.structures.ISubDirection;
import org.xmind.ui.internal.fishbone.structures.SubFishboneStructure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SouthEastRotated
extends AbstractSubFishboneDirection {
    public SouthEastRotated() {
        super(-110.0, true, false, false, 8, 8);
    }

    @Override
    public ISubDirection getSubDirection() {
        return SE;
    }

    @Override
    public void fillFishboneData(IBranchPart branch, FishboneData data, IPrecisionTransformer h, PrecisionRotator r, double spacing, List<IBranchPart> subbranches) {
        IInsertion insertion;
        PrecisionPoint origin = h.getOrigin();
        PrecisionInsets hTopicIns = h.ti(data.topicRefIns);
        PrecisionRectangle hBranchBounds = h.ti(data.branchRefIns).getBounds(origin);
        PrecisionRectangle rhBranchBounds = h.ti(data.rBranchRefIns).getBounds(origin);
        double sin = r.sin();
        double ctg = r.cos() / r.sin();
        PrecisionPoint joint = origin.getTranslated(0.0, hTopicIns.bottom);
        IPlusMinusPart plusMinus = branch.getPlusMinus();
        if (plusMinus != null) {
            joint.x -= (double)plusMinus.getFigure().getPreferredSize().width;
        }
        int insIndex = (insertion = (IInsertion)MindMapUtils.getCache((IPart)branch, (String)"org.xmind.ui.branchCache.insertion")) == null ? -1 : insertion.getIndex();
        Dimension insSize = insertion == null ? null : insertion.getSize();
        double insHeight = insSize == null ? 0 : insSize.height;
        IStructure structure = branch.getBranchPolicy().getStructure((IGraphicalPart)branch);
        BoundaryLayoutHelper helper = ((SubFishboneStructure)structure).getBoundaryLayoutHelper(branch);
        int i = 0;
        while (i < subbranches.size()) {
            PrecisionInsets rhChildBranchIns;
            PrecisionInsets hChildBranchIns;
            IBranchPart subBranch = subbranches.get(i);
            IFigure subBranchFigure = subBranch.getFigure();
            Insets ins = helper.getInsets(subBranch);
            PrecisionInsets hChildBorder = h.ti(new PrecisionInsets(ins));
            PrecisionInsets rhChildBorder = r.ti(hChildBorder);
            IStructure bsa = subBranch.getBranchPolicy().getStructure((IGraphicalPart)subBranch);
            if (bsa instanceof SubFishboneStructure) {
                SubFishboneStructure sfsa = (SubFishboneStructure)bsa;
                FishboneData subData = sfsa.getCastedData(subBranch).getFishboneData();
                hChildBranchIns = h.ti(subData.branchRefIns);
                rhChildBranchIns = h.ti(subData.rBranchRefIns);
            } else {
                PrecisionInsets childBranchNormal = new PrecisionInsets(((IReferencedFigure)subBranchFigure).getReferenceDescription());
                hChildBranchIns = h.ti(childBranchNormal);
                rhChildBranchIns = r.ti(hChildBranchIns);
            }
            double dy = rhChildBranchIns.top;
            double dx1 = Math.abs((hChildBorder.top + hChildBranchIns.top) / sin);
            if (insIndex >= 0 && i == insIndex) {
                dx1 += Math.abs(insHeight / sin);
            }
            double dx2 = Math.abs(dy * ctg);
            double dx = dx1 + dx2;
            PrecisionPoint hChildRef = joint.getTranslated(-dx, dy + 3.0);
            PrecisionPoint rhChildRef = r.rp(hChildRef);
            data.addChildOffset(subBranch, h.rp(rhChildRef));
            hBranchBounds.union(rhChildBranchIns.getBounds(hChildRef).expand(rhChildBorder));
            rhBranchBounds.union(hChildBranchIns.getBounds(rhChildRef).expand(hChildBorder));
            double dx3 = Math.abs((hChildBorder.bottom + hChildBranchIns.bottom) / sin);
            joint.x -= dx1 + dx3 + spacing;
            ++i;
        }
        data.branchRefIns = h.rr(hBranchBounds).getInsets(origin);
        data.rBranchRefIns = h.rr(rhBranchBounds).getInsets(origin);
    }
}

