/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.fishbone.structures;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.geometry.IPrecisionTransformer;
import org.xmind.gef.draw2d.geometry.PrecisionInsets;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.geometry.PrecisionRotator;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.BoundaryLayoutHelper;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.internal.fishbone.structures.AbstractSubFishboneDirection;
import org.xmind.ui.internal.fishbone.structures.FishboneData;
import org.xmind.ui.internal.fishbone.structures.ISubDirection;
import org.xmind.ui.internal.fishbone.structures.SubFishboneStructure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NorthEastNormal
extends AbstractSubFishboneDirection {
    public NorthEastNormal() {
        super(false, false, false, 16, 8);
    }

    @Override
    public ISubDirection getSubDirection() {
        return NER;
    }

    @Override
    public void fillFishboneData(IBranchPart branch, FishboneData data, IPrecisionTransformer h, PrecisionRotator r, double spacing, List<IBranchPart> subbranches) {
        PrecisionPoint origin = h.getOrigin();
        PrecisionInsets hTopicIns = h.ti(data.topicRefIns);
        PrecisionRectangle hBranchBounds = h.ti(data.branchRefIns).getBounds(origin);
        PrecisionRectangle rhBranchBounds = h.ti(data.rBranchRefIns).getBounds(origin);
        double sin = r.sin();
        double ctg = r.cos() / r.sin();
        PrecisionPoint joint = origin.getTranslated(hTopicIns.right, hTopicIns.bottom);
        IPlusMinusPart plusMinus = branch.getPlusMinus();
        if (plusMinus != null) {
            joint.x += (double)plusMinus.getFigure().getPreferredSize().width;
        }
        PrecisionPoint joint2 = joint.getCopy();
        IInsertion insertion = (IInsertion)MindMapUtils.getCache((IPart)branch, (String)"org.xmind.ui.branchCache.insertion");
        int insIndex = insertion == null ? -1 : insertion.getIndex();
        Dimension insSize = insertion == null ? null : insertion.getSize();
        double insHeight = insSize == null ? 0 : insSize.height;
        IStructure structure = branch.getBranchPolicy().getStructure((IGraphicalPart)branch);
        BoundaryLayoutHelper helper = ((SubFishboneStructure)structure).getBoundaryLayoutHelper(branch);
        double dxT = 0.0;
        double width = 0.0;
        double len = 0.0;
        int i = 0;
        while (i < subbranches.size()) {
            double jdx;
            double dx3;
            PrecisionPoint hChildRef;
            double dx;
            PrecisionInsets rhChildBranch;
            PrecisionInsets hChildBranch;
            IBranchPart subBranch = subbranches.get(i);
            IFigure subBranchFigure = subBranch.getFigure();
            Insets ins = helper.getInsets(subBranch);
            PrecisionInsets hChildBorder = h.t(new PrecisionInsets(ins));
            PrecisionInsets rhChildBorder = r.ti(hChildBorder);
            IStructure bsa = subBranch.getBranchPolicy().getStructure((IGraphicalPart)subBranch);
            if (bsa instanceof SubFishboneStructure) {
                SubFishboneStructure sfsa = (SubFishboneStructure)bsa;
                FishboneData subData = sfsa.getCastedData(subBranch).getFishboneData();
                hChildBranch = h.ti(subData.branchRefIns);
                rhChildBranch = h.ti(subData.rBranchRefIns);
            } else {
                PrecisionInsets childBranchNormal = new PrecisionInsets(((IReferencedFigure)subBranchFigure).getReferenceDescription());
                rhChildBranch = h.ti(childBranchNormal);
                hChildBranch = r.ti(rhChildBranch);
            }
            double dy = -rhChildBranch.bottom - hChildBorder.bottom;
            double dx1 = Math.abs(dy * ctg);
            if (hChildBorder.right != 0.0) {
                dx = hChildBorder.right + rhChildBranch.left;
            } else {
                double dx2 = Math.abs(hChildBranch.top / sin);
                dx = dx1 + dx2;
            }
            if (insIndex >= 0 && i == insIndex) {
                dx += Math.abs(insHeight / sin);
            }
            if (hChildBorder.right != 0.0) {
                joint.x = joint2.x;
                hChildRef = joint2.getTranslated(dx, dy);
            } else {
                joint2.x = joint.x;
                hChildRef = joint.getTranslated(dx, dy);
            }
            hChildRef.y -= hChildBorder.bottom;
            if (hChildBorder.getHeight() != 0.0) {
                if (dxT <= hChildBranch.getWidth() * r.cos() + joint.x) {
                    dxT = hChildBranch.getWidth() * r.cos() + joint.x;
                }
                if (width <= rhChildBranch.right) {
                    width = rhChildBranch.right;
                    len = joint.x + dx + width;
                }
            }
            PrecisionPoint rhChildRef = r.tp(hChildRef);
            hBranchBounds.union(rhChildBranch.getBounds(hChildRef).expand(hChildBorder));
            rhBranchBounds.union(hChildBranch.getBounds(rhChildRef).expand(rhChildBorder));
            data.addChildOffset(subBranch, h.rp(hChildRef));
            if (hChildBorder.left != 0.0) {
                dx3 = Math.abs(hChildBranch.bottom / sin);
                double dxB = joint.x + dx1 - dx3 + rhChildBranch.right + hChildBorder.left;
                if (dxT < dxB) {
                    dx += hChildBorder.left + rhChildBranch.right;
                } else {
                    double d = joint.x + dx;
                    double cha = len - d;
                    dx += rhChildBorder.left + cha;
                }
                jdx = dx;
            } else {
                dx3 = Math.abs(hChildBranch.bottom / sin);
                jdx = dx - dx1 + dx3;
                dx += rhChildBranch.right;
            }
            joint2.x += dx + spacing;
            joint.x += jdx + spacing;
            ++i;
        }
        data.branchRefIns = h.rr(hBranchBounds).getInsets(origin);
        data.rBranchRefIns = h.rr(rhBranchBounds).getInsets(origin);
    }
}

