/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet;

import java.util.List;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.ModifyCommand;
import org.xmind.ui.internal.spreadsheet.structures.ColumnHead;
import org.xmind.ui.internal.spreadsheet.structures.ColumnOrder;

public class ModifyColumnOrderCommand
extends ModifyCommand {
    public ModifyColumnOrderCommand(ITopic topic, ColumnOrder newColumnOrder) {
        super((Object)topic, (Object)newColumnOrder);
    }

    protected Object getValue(Object source) {
        if (source instanceof ITopic) {
            return ColumnOrder.createFromTopic((ITopic)source);
        }
        return null;
    }

    protected void setValue(Object source, Object value) {
        if (source instanceof ITopic) {
            ITopic topic = (ITopic)source;
            if (value == null || value instanceof ColumnOrder) {
                ColumnOrder order = (ColumnOrder)value;
                if (order == null || order.isEmpty()) {
                    this.deleteColumnOrder(topic);
                } else {
                    this.setColumnOrder(topic, order);
                }
            }
        }
    }

    private void deleteColumnOrder(ITopic topic) {
        topic.deleteExtension("org.xmind.ui.spreadsheet");
        this.fireEvent(topic);
    }

    private void setColumnOrder(ITopic topic, ColumnOrder order) {
        ITopicExtension extension = topic.createExtension("org.xmind.ui.spreadsheet");
        ITopicExtensionElement content = extension.getContent();
        List oldValues = content.getChildren("columns");
        Object[] objectArray = oldValues.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            content.deleteChild((ITopicExtensionElement)o);
            ++n2;
        }
        ITopicExtensionElement columnsEle = content.createChild("columns");
        for (ColumnHead head : order.getHeads()) {
            ITopicExtensionElement column = columnsEle.createChild("column");
            column.setTextContent(head.toString());
        }
        this.fireEvent(topic);
    }

    private void fireEvent(ITopic topic) {
        if (topic instanceof ICoreEventSource) {
            ICoreEventSource source = (ICoreEventSource)topic;
            source.getCoreEventSupport().dispatchTargetChange(source, "org.xmind.ui.spreadsheet.coreEvent.modifyColumnOrder", null);
        }
    }
}

