/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spelling;

import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordTokenizer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.ui.internal.spelling.ISpellCheckerVisitor;
import org.xmind.ui.internal.spelling.SpellCheckerAgent;
import org.xmind.ui.texteditor.IControlContentAdapter2;

public class SpellingHelper1
implements Listener,
ITextListener,
SpellCheckListener {
    private static final int DEFAULT_CHECK_DELAY = 500;
    private IControlContentAdapter2 contentAdapter;
    private SpellChecker spellChecker;
    private ITextViewer textViewer;
    private Control control;
    private Runnable checkJob;
    private IDocument document;
    private List<WordData> errorWords = new ArrayList<WordData>();

    public SpellingHelper1(ITextViewer textViewer, IControlContentAdapter2 contentAdapter) {
        this.textViewer = textViewer;
        this.document = textViewer.getDocument();
        this.contentAdapter = contentAdapter;
        this.init();
    }

    private void init() {
        this.control = this.textViewer.getTextWidget();
        this.control.addListener(9, (Listener)this);
        this.control.addListener(12, (Listener)this);
        this.textViewer.addTextListener((ITextListener)this);
        SpellCheckerAgent.visitSpellChecker(new ISpellCheckerVisitor(){

            public void handleWith(SpellChecker spellChecker) {
                if (SpellingHelper1.this.control.isDisposed()) {
                    return;
                }
                SpellingHelper1.this.spellChecker = spellChecker;
                spellChecker.addSpellCheckListener((SpellCheckListener)SpellingHelper1.this);
                SpellingHelper1.this.check();
            }
        });
    }

    protected void check() {
        this.checkJob = new Runnable(){

            public void run() {
                if (SpellingHelper1.this.checkJob != this) {
                    return;
                }
                if (!SpellingHelper1.this.control.isDisposed()) {
                    SpellingHelper1.this.doCheck();
                    SpellingHelper1.this.control.redraw();
                }
                SpellingHelper1.this.checkJob = null;
            }
        };
        Display.getCurrent().timerExec(this.getCheckDelay(), this.checkJob);
    }

    private void doCheck() {
        if (this.control.isDisposed()) {
            return;
        }
        if (this.spellChecker != null) {
            String content = this.contentAdapter.getControlContents(this.control);
            if (content == null || "".equals(content.trim())) {
                return;
            }
            this.errorWords.clear();
            if (this.document != null) {
                this.spellChecker.checkSpelling((WordTokenizer)new StringWordTokenizer(content));
            }
        }
    }

    public void textChanged(TextEvent event) {
        DocumentEvent docEvent = event.getDocumentEvent();
        if (docEvent != null) {
            this.document = docEvent.getDocument();
        }
        this.check();
    }

    public void handleEvent(Event event) {
        if (this.control.isDisposed()) {
            return;
        }
        int type = event.type;
        switch (type) {
            case 9: {
                this.paintSpellError(event.gc);
                break;
            }
            case 12: {
                this.handleDispose();
            }
        }
    }

    public void spellingError(SpellCheckEvent event) {
        if (this.control.isDisposed()) {
            return;
        }
        int start = event.getWordContextPosition();
        int length = event.getInvalidWord().length();
        WordData word = new WordData(start, length);
        this.errorWords.add(word);
    }

    private void paintSpellError(GC gc) {
        int lineStyle = gc.getLineStyle();
        int lineWidth = gc.getLineWidth();
        Color lineColor = gc.getForeground();
        gc.setLineWidth(2);
        gc.setLineStyle(3);
        gc.setForeground(Display.getCurrent().getSystemColor(3));
        int charCount = this.contentAdapter.getControlContents(this.control).length();
        if (this.errorWords.isEmpty()) {
            return;
        }
        for (WordData spellData : this.errorWords) {
            int start = spellData.start;
            if (start < 0 || start >= charCount) continue;
            int length = Math.min(spellData.length, charCount - start);
            int i = 0;
            while (i < length) {
                Point p2 = this.contentAdapter.getLocationAtOffset(this.control, start + i + 1);
                int h2 = this.contentAdapter.getLineHeightAtOffset(this.control, start + i + 1);
                p2.y += h2 - 1;
                Point p1 = this.contentAdapter.getLocationAtOffset(this.control, start + i);
                int h1 = this.contentAdapter.getLineHeightAtOffset(this.control, start + i);
                p1.y += h1 - 1;
                if (p1.y != p2.y) {
                    Point size = gc.stringExtent(this.contentAdapter.getControlContents(this.control, start + i, 1));
                    p1.x = p2.x - size.x;
                    p1.y = p2.y;
                }
                gc.drawLine(p1.x, p1.y, p2.x, p2.y);
                ++i;
            }
        }
        gc.setLineWidth(lineWidth);
        gc.setLineStyle(lineStyle);
        gc.setForeground(lineColor);
    }

    private void handleDispose() {
        this.errorWords.clear();
        this.checkJob = null;
        if (this.spellChecker != null) {
            this.spellChecker.removeSpellCheckListener((SpellCheckListener)this);
            this.spellChecker = null;
        }
    }

    protected int getCheckDelay() {
        return 500;
    }

    private class WordData {
        int start;
        int length;

        public WordData(int start, int length) {
            this.start = start;
            this.length = length;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WordData)) {
                return false;
            }
            WordData sd = (WordData)obj;
            return this.start == sd.start && sd.length == this.length;
        }
    }
}

