/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.util.FileUtils;

public class DirectoryOutputTarget
implements IOutputTarget {
    private File dir;

    public DirectoryOutputTarget(String path) {
        this.dir = new File(path);
    }

    public DirectoryOutputTarget(File file) {
        this.dir = file;
    }

    public OutputStream getEntryStream(String entryName) {
        if (!this.isAvailable()) {
            return null;
        }
        try {
            File file = new File(this.dir, entryName);
            FileUtils.ensureFileParent(file);
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public boolean isEntryAvaialble(String entryName) {
        return this.isAvailable();
    }

    public boolean isAvailable() {
        FileUtils.ensureDirectory(this.dir);
        return this.dir.exists() && this.dir.isDirectory();
    }

    public void setEntryTime(String entryName, long time) {
        File f = new File(this.dir, entryName);
        if (f.exists()) {
            f.setLastModified(time);
        }
    }
}

