/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xmind.core.io.IInputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryInputSource
implements IInputSource {
    private File dir;
    private FileFilter filter;

    public DirectoryInputSource(File file) {
        this(file, null);
    }

    public DirectoryInputSource(String path) {
        this(new File(path), null);
    }

    public DirectoryInputSource(File file, FileFilter filter) {
        this.dir = file;
        this.filter = filter;
    }

    public File getFile() {
        return this.dir;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public String getName() {
        return this.dir.getName();
    }

    @Override
    public Iterator<String> getEntries() {
        ArrayList<String> list = new ArrayList<String>();
        this.getSubFiles("", this.dir, list);
        return list.iterator();
    }

    private void getSubFiles(String parentEntry, File parentFile, List<String> list) {
        if (!parentFile.isDirectory()) {
            return;
        }
        File[] fileArray = parentFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.filter == null || this.filter.accept(file)) {
                String entryName = "".equals(parentEntry) ? file.getName() : String.valueOf(parentEntry) + "/" + file.getName();
                list.add(entryName);
                this.getSubFiles(entryName, file, list);
            }
            ++n2;
        }
    }

    protected boolean isAvailable() {
        return this.dir.exists() && this.dir.isDirectory();
    }

    @Override
    public boolean hasEntry(String entryName) {
        File f = new File(this.dir, entryName);
        return f.exists() && f.canRead() && (this.filter == null || this.filter.accept(f));
    }

    @Override
    public InputStream getEntryStream(String entryName) {
        if (!this.isAvailable()) {
            return null;
        }
        try {
            File file = new File(this.dir, entryName);
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public boolean closeEntryStream(String entryPath, InputStream stream) {
        try {
            stream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public long getEntrySize(String entryName) {
        File f = new File(this.dir, entryName);
        if (f.exists()) {
            return f.length();
        }
        return -1L;
    }

    @Override
    public long getEntryTime(String entryName) {
        File f = new File(this.dir, entryName);
        if (f.exists()) {
            return f.lastModified();
        }
        return -1L;
    }
}

