/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.xmind.core.Core;
import org.xmind.core.io.IOutputTarget;

public class ZipStreamOutputTarget
implements IOutputTarget {
    private ZipOutputStream zip;
    private ZipEntry currentEntry;

    public ZipStreamOutputTarget(ZipOutputStream zip) {
        this.zip = zip;
    }

    public void close() {
        try {
            this.zip.close();
            return;
        }
        catch (IOException e) {
            Core.getLogger().log(e);
            return;
        }
    }

    public OutputStream getEntryStream(String entryName) {
        try {
            this.currentEntry = new ZipEntry(entryName);
            this.zip.putNextEntry(this.currentEntry);
            return new ZipEntryOutputStream(this.zip);
        }
        catch (IOException e) {
            Core.getLogger().log(e);
            return null;
        }
    }

    public boolean isEntryAvaialble(String entryName) {
        return this.zip != null;
    }

    public void setEntryTime(String entryName, long time) {
        if (entryName != null && this.currentEntry != null && this.currentEntry.getName().equals(entryName)) {
            this.currentEntry.setTime(time);
        }
    }

    private static class ZipEntryOutputStream
    extends FilterOutputStream {
        public ZipEntryOutputStream(ZipOutputStream out) {
            super(out);
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void close() throws IOException {
            try {
                ((ZipOutputStream)this.out).closeEntry();
            }
            catch (IOException iOException) {}
        }
    }
}

