/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.event;

import java.util.ArrayList;
import java.util.List;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.internal.event.CoreEventRegistration;

public class CoreEventRegistrationList {
    public static final int ONLY_ONCE = 1;
    public static final int ONLY_NORMAL = 2;
    public static final int ALL = 3;
    private List<CoreEventRegistration> regs;
    private int numOnceRegs = 0;

    public void add(CoreEventRegistration reg) {
        if (reg == null) {
            return;
        }
        if (this.regs == null) {
            this.regs = new ArrayList<CoreEventRegistration>(4);
        }
        this.regs.add(reg);
        if (reg.isOnce()) {
            ++this.numOnceRegs;
        }
    }

    public void remove(CoreEventRegistration reg) {
        if (reg == null || this.regs == null) {
            return;
        }
        this.regs.remove(reg);
        if (reg.isOnce()) {
            --this.numOnceRegs;
        }
        if (this.regs.isEmpty()) {
            this.regs = null;
        }
    }

    public boolean isEmpty() {
        return this.regs == null || this.regs.isEmpty();
    }

    public void fireCoreEvent(CoreEvent e, int group) {
        Object[] array;
        if (this.regs == null) {
            return;
        }
        Object[] objectArray = array = this.regs.toArray();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            CoreEventRegistration reg = (CoreEventRegistration)obj;
            if (group == 3 || group == 1 && reg.isOnce() || group == 2 && !reg.isOnce()) {
                reg.getListener().handleCoreEvent(e);
                if (reg.isOnce()) {
                    reg.unregister();
                }
            }
            ++n2;
        }
    }

    public boolean hasRegistration(ICoreEventRegistration reg) {
        return this.regs != null && this.regs.contains(reg);
    }

    public boolean hasOnceRegistration() {
        return this.numOnceRegs > 0;
    }
}

