/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IAdaptable;
import org.xmind.core.internal.ElementRegistry;
import org.xmind.core.internal.dom.INodeAdaptableFactory;
import org.xmind.core.internal.dom.INodeAdaptableProvider;

public class NodeAdaptableProvider
implements INodeAdaptableProvider {
    private ElementRegistry registry;
    private INodeAdaptableFactory factory;

    public NodeAdaptableProvider(ElementRegistry registry, INodeAdaptableFactory factory) {
        this.registry = registry;
        this.factory = factory;
    }

    public IAdaptable getAdaptable(Node node) {
        Object e;
        String id;
        if (node == null) {
            return null;
        }
        if (node instanceof Element && (id = ((Element)node).getAttribute("id")) != null && !"".equals(id) && (e = this.registry.getElement(id)) instanceof IAdaptable) {
            return (IAdaptable)e;
        }
        Object e2 = this.registry.getElement(node);
        if (e2 instanceof IAdaptable) {
            return (IAdaptable)e2;
        }
        IAdaptable adaptable = this.createAdaptable(node);
        if (adaptable != null) {
            this.register(adaptable, node);
            return adaptable;
        }
        return null;
    }

    private void register(IAdaptable adapter, Node node) {
        String id;
        if (node instanceof Element && (id = ((Element)node).getAttribute("id")) != null && !"".equals(id)) {
            this.registry.registerByKey(id, adapter);
            return;
        }
        this.registry.registerByKey(node, adapter);
    }

    private IAdaptable createAdaptable(Node node) {
        IAdaptable adaptable = this.factory.createAdaptable(node);
        if (adaptable != null && adaptable.getAdapter(Node.class) == node) {
            return adaptable;
        }
        return null;
    }
}

