/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.marker.AbstractMarkerResource;
import org.xmind.core.marker.IMarker;

public class MarkerResource
extends AbstractMarkerResource {
    private IInputSource source;
    private IOutputTarget target;

    public MarkerResource(IMarker marker, IInputSource source, IOutputTarget target) {
        super(marker);
        this.source = source;
        this.target = target;
    }

    public InputStream getInputStream() {
        if (this.source != null && this.source.hasEntry(this.getFullPath())) {
            return new InnerInputStream();
        }
        return null;
    }

    public OutputStream getOutputStream() {
        if (this.target != null && this.target.isEntryAvaialble(this.getFullPath())) {
            return new InnerOutputStream();
        }
        return null;
    }

    private class InnerInputStream
    extends InputStream {
        private InputStream is;

        private InnerInputStream() {
        }

        private void ensureOpen() {
            if (this.is == null) {
                this.is = MarkerResource.this.source.getEntryStream(MarkerResource.this.getFullPath());
            }
        }

        public int available() throws IOException {
            this.ensureOpen();
            return this.is.available();
        }

        public void close() throws IOException {
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
        }

        public void mark(int readlimit) {
            this.ensureOpen();
            this.is.mark(readlimit);
        }

        public boolean markSupported() {
            this.ensureOpen();
            return this.is.markSupported();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            return this.is.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            this.ensureOpen();
            return this.is.read(b);
        }

        public void reset() throws IOException {
            this.ensureOpen();
            this.is.reset();
        }

        public long skip(long n) throws IOException {
            this.ensureOpen();
            return this.is.skip(n);
        }

        public int read() throws IOException {
            return this.is.read();
        }
    }

    private class InnerOutputStream
    extends OutputStream {
        private OutputStream os;

        private InnerOutputStream() {
        }

        private void ensureOpen() {
            if (this.os == null) {
                this.os = MarkerResource.this.target.getEntryStream(MarkerResource.this.getFullPath());
            }
        }

        public void close() throws IOException {
            if (this.os != null) {
                this.os.close();
                this.os = null;
            }
        }

        public void flush() throws IOException {
            this.ensureOpen();
            this.os.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            this.os.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.ensureOpen();
            this.os.write(b);
        }

        public void write(int b) throws IOException {
            this.ensureOpen();
            this.os.write(b);
        }
    }
}

