/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IEncryptionData;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.FileEntry;
import org.xmind.core.internal.dom.EncryptionDataImpl;
import org.xmind.core.internal.dom.InternalDOMUtils;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.security.Crypto;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEntryImpl
extends FileEntry {
    private static final List<IFileEntry> NO_SUB_FILE_ENTRIES = Collections.emptyList();
    private Element implementation;
    private ManifestImpl ownedManifest;
    private Integer refCount = null;
    private EncryptionDataImpl encData;
    private boolean ignoreEncryption = false;

    public FileEntryImpl(Element implementation, ManifestImpl ownedManifest) {
        this.implementation = implementation;
        this.ownedManifest = ownedManifest;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    @Override
    public String getMediaType() {
        return this.implementation.getAttribute("media-type");
    }

    public IManifest getOwnedManifest() {
        return this.ownedManifest;
    }

    @Override
    public String getPath() {
        return this.implementation.getAttribute("full-path");
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Element.class) {
            return this.implementation;
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FileEntryImpl)) {
            return false;
        }
        FileEntryImpl that = (FileEntryImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return DOMUtils.toString(this.implementation);
    }

    @Override
    public int getReferenceCount() {
        return this.refCount == null ? 0 : this.refCount;
    }

    @Override
    public boolean hasBeenReferred() {
        return this.refCount != null;
    }

    @Override
    public void increaseReference() {
        IFileEntry parentEntry;
        String parent;
        int c = this.getReferenceCount();
        this.refCount = c + 1;
        if (c <= 0) {
            this.ownedManifest.insertFileEntry(this);
        }
        if ((parent = InternalDOMUtils.getParentPath(this.getPath())) != null && (parentEntry = this.ownedManifest.getFileEntry(parent)) != null) {
            parentEntry.increaseReference();
        }
    }

    @Override
    public void decreaseReference() {
        IFileEntry parentEntry;
        String parent;
        if (this.refCount == null) {
            return;
        }
        int c = this.refCount;
        this.refCount = --c;
        if (c <= 0) {
            this.ownedManifest.removeFileEntry(this);
        }
        if ((parent = InternalDOMUtils.getParentPath(this.getPath())) != null && (parentEntry = this.ownedManifest.getFileEntry(parent)) != null) {
            parentEntry.decreaseReference();
        }
    }

    private IStorage getStorage() {
        IWorkbook wb = this.ownedManifest.getOwnedWorkbook();
        if (wb != null) {
            return wb.getTempStorage();
        }
        return null;
    }

    @Override
    public InputStream getInputStream() {
        if (this.isDirectory()) {
            return null;
        }
        IStorage storage = this.getStorage();
        if (storage != null) {
            try {
                return storage.getInputSource().getEntryStream(this.getPath());
            }
            catch (CoreException e) {
                Core.getLogger().log(e);
            }
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.isDirectory()) {
            return null;
        }
        IStorage storage = this.getStorage();
        if (storage != null) {
            try {
                return storage.getOutputTarget().getEntryStream(this.getPath());
            }
            catch (CoreException e) {
                Core.getLogger().log(e);
            }
        }
        return null;
    }

    @Override
    public long getTime() {
        IStorage storage = this.getStorage();
        if (storage != null) {
            try {
                return storage.getInputSource().getEntryTime(this.getPath());
            }
            catch (CoreException e) {
                Core.getLogger().log(e);
            }
        }
        return -1L;
    }

    @Override
    public void setTime(long time) {
        IStorage storage = this.getStorage();
        if (storage != null) {
            try {
                storage.getOutputTarget().setEntryTime(this.getPath(), time);
            }
            catch (CoreException e) {
                Core.getLogger().log(e);
            }
        }
    }

    @Override
    public List<IFileEntry> getSubEntries() {
        if (!this.isDirectory()) {
            return NO_SUB_FILE_ENTRIES;
        }
        String path = this.getPath();
        Collection<IFileEntry> all = this.ownedManifest.getAllRegisteredEntries();
        ArrayList<IFileEntry> ret = new ArrayList<IFileEntry>(all);
        Iterator<IFileEntry> it = ret.iterator();
        while (it.hasNext()) {
            IFileEntry e = it.next();
            if (e == this) {
                it.remove();
                continue;
            }
            String p = e.getPath();
            if (InternalDOMUtils.isParentPath(p, path)) continue;
            it.remove();
        }
        return ret;
    }

    @Override
    public boolean isDirectory() {
        return this.getPath().endsWith("/");
    }

    @Override
    public long getSize() {
        IStorage storage = this.getStorage();
        if (storage != null) {
            try {
                return storage.getInputSource().getEntrySize(this.getPath());
            }
            catch (CoreException e) {
                Core.getLogger().log(e);
            }
        }
        return -1L;
    }

    @Override
    public IEncryptionData getEncryptionData() {
        Element encEle = DOMUtils.getFirstChildElementByTag(this.implementation, "encryption-data");
        if (encEle == null) {
            if (this.encData != null) {
                this.encData = null;
            }
        } else if (this.encData == null) {
            this.encData = new EncryptionDataImpl(encEle, this);
        }
        return this.encData;
    }

    @Override
    public IEncryptionData createEncryptionData() {
        IEncryptionData ed = this.getEncryptionData();
        if (ed != null) {
            return ed;
        }
        Element encEle = DOMUtils.createElement(this.implementation, "encryption-data");
        this.encData = new EncryptionDataImpl(encEle, this);
        Crypto.initEncryptionData(this.encData);
        return this.encData;
    }

    @Override
    public void deleteEncryptionData() {
        if (this.encData != null) {
            Element encEle = this.encData.getImplementation();
            if (encEle != null && encEle.getParentNode() == this.implementation) {
                this.implementation.removeChild(encEle);
            }
            this.encData = null;
        }
    }

    public void setIgnoreEncryption(boolean ignoreEncryption) {
        this.ignoreEncryption = ignoreEncryption;
    }

    public boolean isIgnoreEncryption() {
        return this.ignoreEncryption;
    }
}

