/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmind.core.ICloneData;
import org.xmind.core.internal.ICloneDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneData
implements ICloneData {
    private Collection<Object> sources;
    private ICloneData parent;
    private Map<Object, Object> clonedElements;
    private Map<Object, List<ICloneDataListener>> listeners;
    private Map<Object, Object> caches;

    public CloneData(Collection<? extends Object> sources, ICloneData parent) {
        this.sources = new ArrayList<Object>(sources);
        this.parent = parent;
    }

    @Override
    public Object get(Object source) {
        Object cloned;
        Object object = cloned = this.clonedElements == null ? null : this.clonedElements.get(source);
        if (cloned == null && this.parent != null) {
            cloned = this.parent.get(source);
        }
        return cloned;
    }

    @Override
    public boolean hasCloned() {
        if (this.clonedElements != null) {
            for (Object cloned : this.clonedElements.values()) {
                if (cloned == null) continue;
                return true;
            }
        }
        if (this.parent != null) {
            return this.parent.hasCloned();
        }
        return false;
    }

    @Override
    public Collection<Object> getCloneds() {
        ArrayList<Object> list = new ArrayList<Object>(this.sources.size());
        for (Object source : this.sources) {
            Object cloned = this.get(source);
            if (cloned == null) continue;
            list.add(cloned);
        }
        return list;
    }

    @Override
    public Collection<Object> getSources() {
        return this.sources;
    }

    public ICloneData getParent() {
        return this.parent;
    }

    @Override
    public void put(Object source, Object cloned) {
        if (this.clonedElements == null) {
            this.clonedElements = new HashMap<Object, Object>();
        }
        this.clonedElements.put(source, cloned);
        if (this.parent != null) {
            this.parent.put(source, cloned);
        }
        this.fireObjectCloned(source, cloned);
    }

    public void cache(Object key, Object value) {
        if (this.caches == null) {
            this.caches = new HashMap<Object, Object>();
        }
        this.caches.put(key, value);
    }

    public Object getCache(Object key) {
        return this.caches == null ? null : this.caches.get(key);
    }

    private void fireObjectCloned(Object source, Object cloned) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        List<ICloneDataListener> list = this.listeners.get(source);
        if (list == null || list.isEmpty()) {
            this.listeners.remove(source);
            return;
        }
        Object[] objectArray = list.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((ICloneDataListener)o).objectCloned(source, cloned);
            ++n2;
        }
    }

    public void addCloneDataListener(Object source, ICloneDataListener listener) {
        List<ICloneDataListener> list;
        if (this.listeners == null) {
            this.listeners = new HashMap<Object, List<ICloneDataListener>>();
        }
        if ((list = this.listeners.get(source)) == null) {
            list = new ArrayList<ICloneDataListener>();
            this.listeners.put(source, list);
        }
        list.add(listener);
    }

    public void removeCloneDataListener(Object source, ICloneDataListener listener) {
        if (this.listeners == null) {
            return;
        }
        List<ICloneDataListener> list = this.listeners.get(source);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.isEmpty()) {
            this.listeners.remove(source);
        }
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    @Override
    public boolean isCloned(Object source) {
        if (this.clonedElements != null && this.clonedElements.containsKey(source)) {
            return true;
        }
        return this.parent != null && this.parent.isCloned(source);
    }

    public String getString(String sourceString) {
        Object cloned;
        Object object = cloned = this.clonedElements == null ? null : this.clonedElements.get(sourceString);
        if (!(cloned != null && cloned instanceof String || this.parent == null)) {
            cloned = this.parent.get(sourceString);
        }
        return cloned instanceof String ? (String)cloned : null;
    }
}

