/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.ui.PlatformUI;
import org.xmind.ui.internal.browser.BrowserViewer;

public class MozillaPref {
    private Browser browser;
    private IProxyService service;
    private Map<String, Object> preference = null;
    private IProxyChangeListener proxyChangeListener = new IProxyChangeListener(){

        public void proxyInfoChanged(IProxyChangeEvent event) {
            MozillaPref.this.addProxyPref();
            MozillaPref.this.setPref();
        }
    };

    public MozillaPref(BrowserViewer viewer) {
        this.browser = viewer.getBrowser();
        if (viewer.isMozilla()) {
            this.initPref();
        }
    }

    private void initPref() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        this.service = (IProxyService)PlatformUI.getWorkbench().getService(IProxyService.class);
        if (this.service == null) {
            return;
        }
        this.preference = new HashMap<String, Object>();
        this.preference.put("security.warn_entering_secure", false);
        this.preference.put("security.warn_leaving_secure", false);
        this.addProxyPref();
        this.setPref();
        this.service.addProxyChangeListener(this.proxyChangeListener);
        this.browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (MozillaPref.this.service != null) {
                    MozillaPref.this.service.removeProxyChangeListener(MozillaPref.this.proxyChangeListener);
                    MozillaPref.this.service = null;
                }
            }
        });
    }

    private void addProxyPref() {
        IProxyData httpData = this.service.getProxyData("HTTP");
        this.preference.put("network.proxy.http", this.getHost(httpData));
        this.preference.put("network.proxy.http_port", this.getPort(httpData));
        IProxyData socksData = this.service.getProxyData("SOCKS");
        this.preference.put("network.proxy.socks", this.getHost(socksData));
        this.preference.put("network.proxy.socks_port", this.getPort(socksData));
        IProxyData sslData = this.service.getProxyData("HTTPS");
        this.preference.put("network.proxy.ssl", this.getHost(sslData));
        this.preference.put("network.proxy.ssl_port", this.getPort(sslData));
        String nonProxy = null;
        StringBuilder sb = new StringBuilder();
        String[] stringArray = this.service.getNonProxiedHosts();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String host = stringArray[n2];
            sb.append(host);
            sb.append(", ");
            ++n2;
        }
        nonProxy = sb.length() > 2 ? sb.substring(0, sb.length() - 2) : sb.toString();
        this.preference.put("network.proxy.no_proxies_on", nonProxy);
        int enabled = this.service.isProxiesEnabled() ? 1 : 0;
        this.preference.put("network.proxy.type", enabled);
    }

    private void setPref() {
        StringBuilder sb = new StringBuilder();
        String s = "javascript:var prefService = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService);";
        sb.append(s);
        for (Map.Entry<String, Object> e : this.preference.entrySet()) {
            if (e.getValue() instanceof String) {
                String s2 = "prefService.setCharPref('%s', '%s');";
                sb.append(String.format(s2, e.getKey(), e.getValue()));
                continue;
            }
            if (e.getValue() instanceof Integer) {
                String s3 = "prefService.setIntPref('%s', %s);";
                sb.append(String.format(s3, e.getKey(), e.getValue()));
                continue;
            }
            if (!(e.getValue() instanceof Boolean)) continue;
            String s4 = "prefService.setBoolPref('%s', %s);";
            sb.append(String.format(s4, e.getKey(), e.getValue()));
        }
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.setUrl(sb.toString());
        }
    }

    private String getHost(IProxyData pd) {
        return pd.getHost() == null ? "" : pd.getHost();
    }

    private int getPort(IProxyData pd) {
        return pd.getPort() == -1 ? 0 : pd.getPort();
    }
}

